/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.yajilin;

import java.util.ArrayList;
import pencilbox.common.core.Address;
import pencilbox.common.core.AreaBase;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.BoardCopierBase;
import pencilbox.common.core.Rotator;
import pencilbox.common.core.Rotator2;
import pencilbox.common.core.SideAddress;
import pencilbox.yajilin.Board;

public class BoardCopier
extends BoardCopierBase {
    @Override
    public void copyBoardStates(BoardBase src, BoardBase dst, int n) {
        Board s = (Board)src;
        Board d = (Board)dst;
        Rotator rotator = new Rotator(src.getSize(), n);
        rotator.rotateArrayInt3(s.getState(), d.getState());
        Address[] addressArray = src.cellAddrs();
        int n2 = addressArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Address pos0 = addressArray[n3];
            Address pos = rotator.rotateAddress(pos0);
            if (d.isOn(pos)) {
                if (s.getNumber(pos0) >= 0) {
                    d.setArrowNumber(pos, s.getArrowNumber(pos0));
                    d.setArrowDirection(pos, rotator.rotateDirection(s.getArrowDirection(pos0)));
                } else {
                    d.setNumber(pos, s.getNumber(pos0));
                }
            }
            ++n3;
        }
    }

    @Override
    public void copyRegion(BoardBase srcBoardBase, BoardBase boardBase, AreaBase region, Address from, Address to, int rotation) {
        Board srcBoard = (Board)srcBoardBase;
        Board board = (Board)boardBase;
        for (Address s : region) {
            Address d = this.translateAndRotateAddress(s, from, to, rotation);
            if (!board.isOn(d)) continue;
            int number = srcBoard.getNumber(s);
            if (number >= 0 || number == -4 || number == -2) {
                board.eraseLinesAround(d);
            }
            if (number >= 0) {
                int dir = Rotator2.rotateDirection(srcBoard.getArrowDirection(s), rotation);
                number = Board.getNumberValue(number, dir);
            }
            board.changeNumber(d, number);
        }
        ArrayList<SideAddress> list = region.innerBorders();
        for (SideAddress s : list) {
            SideAddress d = Rotator2.translateAndRotateSideAddress(s, from, to, rotation);
            if (!board.isSideOn(d)) continue;
            board.changeState(d, srcBoard.getState(s));
        }
    }

    @Override
    public void eraseRegion(BoardBase srcBoardBase, AreaBase region) {
        Board board = (Board)srcBoardBase;
        ArrayList<SideAddress> list = region.innerBorders();
        for (Comparable<SideAddress> s : list) {
            board.changeState((SideAddress)s, 0);
        }
        for (Comparable<SideAddress> s : region) {
            board.changeNumber((Address)s, -3);
        }
    }
}

