/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.shakashaka;

import java.awt.event.MouseEvent;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.shakashaka.Board;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;
    private int currentState = 0;
    private Address currentStatePos = null;
    private int oldCorner = 0;

    public PanelEventHandler() {
        this.setMaxInputNumber(5);
    }

    @Override
    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Address newPos = this.pointToAddress(e);
        if (!this.isOn(newPos)) {
            this.currentState = 0;
            return;
        }
        int button = this.getMouseButton(e);
        if (button == 1) {
            this.leftPressed(newPos, this.getCorner(e));
        } else if (button == 3) {
            this.rightPressed(newPos);
        }
        this.moveCursor(newPos);
        this.repaint();
    }

    protected void leftPressed(Address pos, int corner) {
        this.toggleStateCorner(pos, corner);
    }

    @Override
    protected void rightPressed(Address pos) {
        this.toggleStateCorner(pos, -3);
    }

    protected void toggleStateCorner(Address pos, int st) {
        if (Board.isNumber(this.board.getNumber(pos))) {
            return;
        }
        int st0 = this.board.getState(pos);
        if (st == st0) {
            this.board.changeState(pos, 0);
            this.currentState = 0;
            this.currentStatePos = pos;
        } else {
            this.board.changeState(pos, st);
            this.currentState = st;
            this.currentStatePos = pos;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseDragged3(e);
        Address newPos = this.pointToAddress(e);
        if (!this.isOn(newPos)) {
            this.oldPos = Address.nowhere();
            return;
        }
        int button = this.getMouseButton(e);
        if (button == 1 || button == 3) {
            if (4 <= this.currentState && this.currentState <= 7) {
                int corner = this.getCorner(e);
                if (newPos.equals(this.oldPos)) {
                    if (corner == this.oldCorner) {
                        return;
                    }
                    this.sweepState(newPos, corner);
                    this.oldCorner = corner;
                } else {
                    this.sweepState(newPos, corner);
                    this.oldCorner = corner;
                    this.moveCursor(newPos);
                    this.oldPos = newPos;
                }
            } else {
                if (newPos.equals(this.oldPos)) {
                    return;
                }
                this.sweepState(newPos, this.currentState);
                this.moveCursor(newPos);
                this.oldPos = newPos;
            }
        } else {
            if (newPos.equals(this.oldPos)) {
                return;
            }
            this.moveCursor(newPos);
            this.oldPos = newPos;
        }
        this.repaint();
    }

    private int getCorner(MouseEvent e) {
        int yy = (e.getY() - this.getPanel().getOffsety()) % this.getPanel().getCellSize();
        int xx = (e.getX() - this.getPanel().getOffsetx()) % this.getPanel().getCellSize();
        int corner = xx < this.getPanel().getHalfCellSize() ? (yy < this.getPanel().getHalfCellSize() ? 4 : 5) : (yy < this.getPanel().getHalfCellSize() ? 7 : 6);
        return corner;
    }

    private void sweepState(Address pos, int corner) {
        if (Board.isNumber(this.board.getNumber(pos))) {
            return;
        }
        if (4 <= this.currentState && this.currentState <= 7) {
            int dX = this.currentStatePos.c() - pos.c();
            int dY = this.currentStatePos.r() - pos.r();
            int cX = 1 - (corner & 2);
            int cY = 1 - (corner + 1 & 2);
            if (corner == this.currentState && (dX == cX && dY + cY == 0 || dX + cX == 0 && dY == cY) || dX == 0 && dY == cY && corner == (this.currentState ^ 1) || dY == 0 && dX == cX && corner == (this.currentState ^ 3)) {
                this.currentStatePos = pos;
                this.currentState = corner;
            } else {
                return;
            }
        }
        this.board.changeState(pos, this.currentState);
    }

    @Override
    protected void numberEntered(Address pos, int num) {
        this.keyEntered(pos, num);
    }

    @Override
    protected void spaceEntered(Address pos) {
        this.keyEntered(pos, -1);
    }

    @Override
    protected void minusEntered(Address pos) {
        this.keyEntered(pos, -2);
    }

    @Override
    protected void plusEntered(Address pos) {
    }

    @Override
    protected void starEntered(Address pos) {
        this.keyEntered(pos, -3);
    }

    protected void keyEntered(Address pos, int key) {
        int n = 0;
        if (this.isProblemEditMode()) {
            if (key >= 0 && key <= 4) {
                n = key;
            } else if (key == 5) {
                n = -2;
            } else if (key == -2) {
                n = -2;
            } else if (key == -1) {
                n = -1;
            }
            this.board.changeNumber(pos, n);
            if (this.isSymmetricPlacementMode()) {
                Address posS = this.getSymmetricPosition(pos);
                if (n >= 0) {
                    n = -2;
                }
                if (n == -1 && Board.isNumber(this.board.getNumber(posS))) {
                    this.board.changeNumber(posS, -1);
                } else if (n == -2 && !Board.isNumber(this.board.getNumber(posS))) {
                    this.board.changeNumber(posS, -2);
                }
            }
        }
    }
}

