package pencilbox.common.factory;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

import pencilbox.common.core.BoardBase;
import pencilbox.common.core.PencilBoxException;
import pencilbox.common.core.Problem;
import pencilbox.common.core.BoardCopierBase;
import pencilbox.common.core.Size;
import pencilbox.common.core.UndoManager;
import pencilbox.common.gui.EventHandlerManager;
import pencilbox.common.gui.Frame;
import pencilbox.common.gui.MenuBase;
import pencilbox.common.gui.MenuCommand;
import pencilbox.common.gui.PanelBase;
import pencilbox.common.gui.PreferencesCopierBase;
import pencilbox.common.io.IOController;


/**
 * PencilBox t@Ng[NX
 */
public class PencilFactory {

	private PencilType pencilType;
	private MenuCommand caller; // Ăяoj[R}h

	/**
	 * @param pencilType
	 */
	public PencilFactory(PencilType pencilType) {
		this.pencilType = pencilType;
	}
	/**
	 * PencilPuzzleCX^X쐬Ď擾
	 * @param pencilType 
	 * @return VPencilPuzzleCX^X
	 */
	public static PencilFactory getInstance(PencilType pencilType) {
		return new PencilFactory(pencilType);
	}
	/**
	 * PencilPuzzleCX^X쐬Ď擾
	 * @param pencilType
	 * @param caller@Ăяoj[R}h
	 * @return@VPencilPuzzleCX^X
	 */
	public static PencilFactory getInstance(PencilType pencilType, MenuCommand caller) {
		PencilFactory f = new PencilFactory(pencilType);
		f.pencilType = pencilType;
		f.caller = caller;
		return f;
	}
	/**
	 * ftHgTCYŃAvP[Vt[B
	 * Launcher, Main gpB
	 * @throws PencilBoxException
	 */
	public void createNewFrame() throws PencilBoxClassException {
		Size size = pencilType.getDefaultSize();
		createNewFrame(size);
	}
	/**
	 * ՖʃTCY^ăAvP[Vt[B
	 * uVKvj[̂̋NŎgpB
	 * @param size
	 * @throws PencilBoxClassException
	 */
	public void createNewFrame(Size size) throws PencilBoxClassException {
		BoardBase board = (BoardBase) ClassUtil.createInstance(pencilType, ClassUtil.BOARD_CLASS);
		board.setSize(size);
		Problem problem = new Problem(board);	
		createNewFrame(problem);
	}
	/**
	 * t@C^ăAvP[Vt[B
	 * uJvj[̋NŎgpB
	 * @param file
	 * @throws PencilBoxException
	 */
	public void createNewFrame(File file) throws PencilBoxException {
		Problem problem = IOController.getInstance(pencilType).openFile(file);
		createNewFrame(problem);
	}
	/**
	 * ^ăAvP[Vt[B
	 * @param file
	 * @throws PencilBoxException
	 */
	public boolean createNewFrame(String string) throws PencilBoxException {
		Problem problem = IOController.getInstance(pencilType).openFile(string);
		if (problem != null) {
			createNewFrame(problem);
			return true;
		}

		return false;
	}
	/**
	 * Problem ^ăAvP[Vt[B
	 * ̃NXōŏIIɍ쐬iKŎgpB
	 * @param problem
	 * @throws PencilBoxClassException
	 */
	public void createNewFrame(Problem problem) throws PencilBoxClassException {
		MenuCommand command = new MenuCommand();
		Frame frame = new Frame();
		MenuBase menu = (MenuBase) ClassUtil.createInstance(pencilType, ClassUtil.MENU_CLASS);
		PanelBase panel = (PanelBase) ClassUtil.createInstance(pencilType, ClassUtil.PANEL_CLASS);
		EventHandlerManager handler = new EventHandlerManager(pencilType);
		frame.setup(panel);
		command.setup(pencilType, frame, panel, handler, problem);
		panel.setup(problem.getBoard());
		handler.setup(panel, problem.getBoard());
		copyPreferences(command);
		menu.setup(command, frame, panel);
		menu.updateCurrentMenuSelection();
		frame.resize();
		if (caller == null) {
			frame.locateAtCenter();
		} else {
			frame.locateAtShiftPosition(caller.getFrame());
		}
		frame.setVisible(true);
	}
	/**
	 * t@Cǂݍœt[ŊJB
	 * uĊJvj[̋NŎgpB
	 * @param file
	 * @throws PencilBoxException
	 */
	public void createNewBoard(File file) throws PencilBoxException {
		Problem problem = IOController.getInstance(pencilType).openFile(file);
		createNewBoard(problem);
	}
	/**
	 * Problem ^ēt[ŊJB
	 * @param problem
	 * @throws PencilBoxClassException
	 */
	public void createNewBoard(Problem problem) throws PencilBoxClassException {
		PanelBase panel = caller.getPanelBase();
		EventHandlerManager handler = caller.getEventHandlerManager();
		Frame frame = caller.getFrame();
		caller.setup(pencilType, problem);
		panel.setup(problem.getBoard());
		handler.setup(panel, problem.getBoard());
		frame.resize();
		frame.locateAtSamePosition();
	}

	/**
	 * Ֆʂ̃t[𕡐
	 * @throws PencilBoxClassException
	 */
	public void duplicateFrame() throws PencilBoxClassException {
		BoardCopierBase copier = (BoardCopierBase) ClassUtil.createInstance(pencilType, ClassUtil.BOARD_COPIER_CLASS);
		Problem src = caller.getProblem();
		Problem problem = new Problem(src, copier.duplicateBoard(src.getBoard()));
		UndoManager um = new UndoManager(problem.getBoard());
		um.copyEdits(src.getBoard().getUndoManager());
		problem.getBoard().setUndoManager(um);
		createNewFrame(problem);
	}

	/**
	 * Ֆʂ]
	 * @param n ]ԍ
	 * @throws PencilBoxClassException
	 */
	public void rotateBoard(int n) throws PencilBoxClassException {
		BoardCopierBase copier = (BoardCopierBase) ClassUtil.createInstance(pencilType, ClassUtil.BOARD_COPIER_CLASS);
		Problem problem = caller.getProblem();
		problem.setBoard(copier.duplicateBoard(problem.getBoard(), n));
		createNewBoard(problem);
	}
	/**
	 * ՖʃTCYύX
	 * @param size ύX̔ՖʃTCY
	 * @throws PencilBoxClassException
	 */
	public void changeBoardSize(Size size) throws PencilBoxClassException {
		BoardCopierBase copier = (BoardCopierBase) ClassUtil.createInstance(pencilType, ClassUtil.BOARD_COPIER_CLASS);
		Problem problem = caller.getProblem();
		problem.setBoard(copier.duplicateBoard(problem.getBoard(), size));
		createNewBoard(problem);
	}
	/**
	 * ̃t[Ăяoꂽꍇ́CĂяot[̐ݒpB
	 * łȂꍇ́CftHgݒt@C̐ݒǂݍށB
	 * @param dst 쐬AvP[V MenuCommand CX^X
	 */
	private void copyPreferences(MenuCommand dst) {
		PreferencesCopierBase copier = PreferencesCopierBase.createInstance(pencilType);
		if (caller == null) {
			File iniFile = new File("pencilbox.ini");
			if (iniFile.canRead()) {
				copier.loadPreferences(dst, iniFile);
			}
		} else {
			copier.copyPreferences(caller, dst);
		}
	}

}
