package pencilbox.common.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;

import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/**
 * ݒCvr[_CAO
 * [__CAOȂ̂ŁC1̃CX^X݂̂𐶐Ďg
 */
public class PrintPreviewDialog extends JDialog {

	private static PrintPreviewDialog instance = new PrintPreviewDialog();

	private PrintRequestAttributeSet attributes;

	/**
	 * PrintPreviewDialog CX^X擾B
	 * @return vr[CX^X
	 */
	public static PrintPreviewDialog getInstance() {
		return instance;
	}

	private PrintPreviewCanvas pcanvas;

	private PrintPreviewDialog() {
		super((Frame)null, true);
		this.setSize(611, 909);
		makeDialog();
		attributes = new HashPrintRequestAttributeSet();
	}

	void makeDialog() {
		this.setTitle("Print Preview");

		pcanvas = new PrintPreviewCanvas();

		PrinterJob job = PrinterJob.getPrinterJob();
		PageFormat pf = job.defaultPage();
		pcanvas.setPageFormat(pf);

		JPanel buttonPanel = new JPanel();

		JButton printButton = new JButton("Print");
		JButton pageSetupButton = new JButton("Page Setup");
//		JButton previewButton = new JButton("Preview");
		JButton closeButton = new JButton("Close");
		JLabel scalingSpinnerLabel = new JLabel("Scaling:");
		JLabel repeatXSpinnerLabel = new JLabel("Repeat X:");
		JLabel repeatYSpinnerLabel = new JLabel("Repeat Y:");

		/**
		 * 
		 * I̓_CAO
		 */
		printButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent event) {
				print();
				setVisible(false);
			}
		});
		/**
		 * W̃y[Wݒ_CAOĂԁB
		 * ݒ肪ύXƐVPageFormatԂ邽߁Cvr[ʂXVB 
		 */
		pageSetupButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent event) {
				pageSetup();
			}
		});

		/**
		 * vr[_CAO
		 */
//		previewButton.addActionListener(new ActionListener() {
//			public void actionPerformed(ActionEvent event) {
//				JDialog d = new JDialog();
//				d.setModal(true);
//				d.getContentPane().add(pcanvas);
//				d.pack();
//				d.setVisible(true);
//			}
//		});

		closeButton.addActionListener(closeAction);

		final JSpinner scalingSpinner = new JSpinner(new SpinnerNumberModel(pcanvas.scaling, 0.099, 4.00, 0.05));
		scalingSpinner.setEditor(new JSpinner.NumberEditor(scalingSpinner, "#%"));
		scalingSpinner.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent e) {
				pcanvas.scaling = ((SpinnerNumberModel)scalingSpinner.getModel()).getNumber().doubleValue();
				pcanvas.repaint();
			}
		});
		final JSpinner repeatXSpinner = new JSpinner(new SpinnerNumberModel(pcanvas.repeatX, 1, 4, 1));
		repeatXSpinner.setEditor(new JSpinner.NumberEditor(repeatXSpinner, "#"));
		repeatXSpinner.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent e) {
				pcanvas.repeatX = ((SpinnerNumberModel)repeatXSpinner.getModel()).getNumber().intValue();
				pcanvas.repaint();
			}
		});
		final JSpinner repeatYSpinner = new JSpinner(new SpinnerNumberModel(pcanvas.repeatY, 1, 4, 1));
		repeatYSpinner.setEditor(new JSpinner.NumberEditor(repeatYSpinner, "#"));
		repeatYSpinner.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent e) {
				pcanvas.repeatY = ((SpinnerNumberModel)repeatYSpinner.getModel()).getNumber().intValue();
				pcanvas.repaint();
			}
		});

		buttonPanel.add(printButton);
		buttonPanel.add(pageSetupButton);
//		buttonPanel.add(previewButton);
		buttonPanel.add(scalingSpinnerLabel);
		buttonPanel.add(scalingSpinner);
		buttonPanel.add(repeatXSpinnerLabel);
		buttonPanel.add(repeatXSpinner);
		buttonPanel.add(repeatYSpinnerLabel);
		buttonPanel.add(repeatYSpinner);
		buttonPanel.add(closeButton);

		Container contentPane = this.getContentPane();
//		if (false) { //	XN[yCɓꍇC
//			JScrollPane jScrollPane = new JScrollPane();
//			jScrollPane.getViewport().add(pcanvas, null);
//			contentPane.add(jScrollPane, BorderLayout.CENTER);
//		} else {
			contentPane.add(pcanvas, BorderLayout.CENTER);
//		}
		contentPane.add(buttonPanel, BorderLayout.NORTH);

		assignKeys();
	}

	/**
	 * B
	 * XP[OȂǂ̈ݒ𔽉f邽߁CPanel̂̂łȂCPreviewCanvasB
	 */
	public void print() {
		PrinterJob job = PrinterJob.getPrinterJob();
		try {
			job.setPrintable(pcanvas);
            if (job.printDialog(attributes)) {
               job.print(attributes);
            }
		} catch (PrinterException e) {
			JOptionPane.showMessageDialog(PrintPreviewDialog.this, e);
		}
	}	

	public void pageSetup() {
		PrinterJob job = PrinterJob.getPrinterJob();
		PageFormat pf = job.pageDialog(attributes);
		if (pf != null) {
			pcanvas.setPageFormat(pf);
			pcanvas.repaint();
		}
	}

	/**
	 * ESCL[Ń_CAO
	 */
	private void assignKeys() {
		InputMap imap = getRootPane().getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
		imap.put(KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), "close");
		getRootPane().getActionMap().put("close", closeAction);
	}

	private Action closeAction = new AbstractAction() {
		public void actionPerformed(ActionEvent event) {
			setVisible(false);
		}
	};

	/**
	 * vr[ʂɃplݒ肷
	 * @param printObject
	 */
	public void setPrintObject(Printable printObject) {
		pcanvas.printObject = printObject;
	}

	/**
	 * _CAO\
	 * @param frame
	 */
	public void showDialog(Frame frame) {
//		PrinterJob job = PrinterJob.getPrinterJob();
//		PageFormat pf = job.defaultPage();
//		PageFormat pf = job.getPageFormat(attributes);
//		if (pf == null) return;
//		pcanvas.setPageFormat(pf);
		this.setLocationRelativeTo(frame);
		this.setVisible(true);
	}

}

/**
 * vgvr[̉ʂƈp`
 */
class PrintPreviewCanvas extends JPanel implements Printable {

	Printable printObject;
	PageFormat pageFormat;
	double scaling = 0.70;  // ̔{
	int repeatX = 1;  // JԂ
	int repeatY = 1;  // cJԂ

	public PrintPreviewCanvas() {
	}

	/**
	 * ͂߁CsƂCy[WݒύXƂɁC
	 * PageFormatɉăvr[XVB
	 * @param pageFormat
	 */
	public void setPageFormat(PageFormat pageFormat) {
		this.pageFormat = pageFormat;
	}

	/* 
	 * 
	 * łPageFormat̓tB[hł͂Ȃ̂̂g邱Ƃɒ
	 * @see java.awt.print.Printable#print(java.awt.Graphics, java.awt.print.PageFormat, int)
	 */
	public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
		if (page >= 1)
			return Printable.NO_SUCH_PAGE;
		Graphics2D g2 = (Graphics2D) g;
		g2.translate(pf.getImageableX(), pf.getImageableY());
		drawPanel(g2);
		return Printable.PAGE_EXISTS;
	}

	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		Graphics2D g2 = (Graphics2D) g;
		double px = pageFormat.getWidth();
		double py = pageFormat.getHeight();
		double scale = 1.0; // scale factor to fit page in window
		if (true) {    // vr[ʂ_CAÕTCYɍ킹ăXP[Oꍇ
			double xoff; // x offset of page start in window
			double yoff; // y offset of page start in window
			double sx = getWidth() - 1;
			double sy = getHeight() - 1;
			if (px / py < sx / sy) { // center horizontally
				scale = sy / py;
				xoff = 0.5 * (sx - scale * px);
				yoff = 0;
			} else { // center vertically
				scale = sx / px;
				xoff = 0;
				yoff = 0.5 * (sy - scale * py);
			}
			g2.translate(xoff, yoff);
		}
		g2.scale(scale, scale);
		// y[WOg
		Rectangle2D pageOutline = new Rectangle2D.Double(0, 0, px, py);
		g2.setPaint(Color.white);
		g2.fill(pageOutline);
		g2.setPaint(Color.black);
		g2.draw(pageOutline);
//		// ̘̈g
//		Rectangle2D imageableOutline = new Rectangle2D.Double(pageFormat.getImageableX(), pageFormat.getImageableY(), pageFormat.getImageableWidth(), pageFormat.getImageableHeight());
//		g2.setPaint(Color.gray);
//		g2.draw(imageableOutline);
		g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
		drawPanel(g2);
	}

	private void drawPanel(Graphics2D g2) {
		g2.scale(scaling, scaling);
		if (printObject instanceof PanelBase) {
			PanelBase p = ((PanelBase)printObject);
			Dimension d = p.getBoardRegionSize();
			for (int r = 0; r < repeatY; r++) {
				for (int c = 0; c < repeatX; c++) {
					p.drawPanel(g2);
					g2.translate(d.width+p.getCellSize(), 0);
				}
				g2.translate((d.width+p.getCellSize())*(-repeatX), d.height+p.getCellSize());
			}
		}
	}

}
