package pencilbox.hashi;

import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.CellEditStep;
import pencilbox.common.core.Direction;
import pencilbox.resource.Messages;


/**
 * uvՖʃNX
 */
public class Board extends BoardBase {

	static final int UNDECIDED_NUMBER = 9;
	static final int NO_NUMBER = 0;

	private Pier[][] pier;
	private Bridge[][] bridgeV;
	private Bridge[][] bridgeH;
	private int maxChain;

	protected void setup() {
		super.setup();
		bridgeV = new Bridge[rows()][cols()];
		bridgeH = new Bridge[rows()][cols()];
		pier = new Pier[rows()][cols()];
		maxChain = 1;
	}

	public void clearBoard() {
		super.clearBoard();
		for (Address p : cellAddrs()) {
			if (isPier(p))
				getPier(p).clear();
		}
	}

	public void initBoard() {
		initChain();
	}
	/**
	 * }Xɐݒ肷
	 * @param r ݒ肷}X̍sW
	 * @param c ݒ肷}X̗W
	 * @param n ݒ肷鐔
	 */
	public void setNumber(int r, int c, int n) {
		setNumber(Address.address(r, c), n);
	}

	public void setNumber(Address p, int n) {
		if (n == NO_NUMBER) {
			if (isPier(p)) {
				removePier(p);
			}
		} else if (n >= 1 && n <= 8 || n == UNDECIDED_NUMBER) {
			if (isPier(p))
				getPier(p).setNumber(n);
			else
				addPier(p, n);
		}
	}
	/**
	 * ύX
	 * @param p }XW
	 * @param n ύX̐ 0 Ȃ琔
	 */
	public void changeNumber(Address p, int n) {
		int prev = getNumber(p);
		if (prev == n)
			return;
		setNumber(p, n);
		if (isRecordUndo()) {
			fireUndoableEditUpdate(new CellEditStep(p, prev, n));
		}
	}
	/**
	 * }X̐擾
	 * @param r ݒ肷}X̍sW
	 * @param c ݒ肷}X̗W
	 * @return }X̐
	 */
	public int getNumber(int r, int c) {
		return getNumber(Address.address(r, c));
	}

	public int getNumber(Address p) {
		if (isPier(p))
			return getPier(p).getNumber();
		else
			return 0;
	}
	/**
	 * ̃}X}Xirjǂ
	 * @param p W
	 * @return }XȂ true
	 */
	public boolean isPier(Address p) {
		return pier[p.r()][p.c()] != null;
	}

	/**
	 * }X̏Ԃ擾
	 * @param r sW
	 * @param c W
	 * @return }X̏
	 */
	public int getState(int r, int c) {
		Address p = Address.address(r, c);
		return getLine(p, Direction.VERT) + (getLine(p, Direction.HORIZ)<<2);
	}
	/**
	 * }X̏Ԃݒ肷
	 * @param r sW
	 * @param c W
	 * @param n }X̏
	 */
	public void setState(int r, int c, int n) {
		Address p = Address.address(r, c);
		setLine(p, Direction.VERT, (n&0x3));
		setLine(p, Direction.HORIZ, ((n>>2) & 0x3));
	}

	public void setState(Address pos, int n) {
		setState(pos.r(), pos.c(), n);
	}
	/**
	 * }Xʉ߂鋴̐Ԃ
	 * @param p W
	 * @param d icj
	 * @return@}Xʉ߂鋴̐
	 */
	public int getLine(Address p, int d) {
		if (getBridge(p, d) != null)
			return getBridge(p, d).getLine();
		return 0;
	}
	/**
	 * }X̏̋̐ݒ肷
	 * @param p }X
	 * @param d icj
	 * @param n ̖{
	 */
	public void setLine(Address p, int d, int n) {
		if (getBridge(p, d) != null)
			getBridge(p, d).setLine(n);
	}

	/**
	 * ̃}X̏ŋĂ邩Ă邩ǂ
	 * @param p W
	 * @return ̃}X̏ŋĂ true
	 */
	public boolean hasCrossedBridge(Address p) {
		int v = getLine(p, Direction.VERT);
		int h = getLine(p, Direction.HORIZ);
		return (v>0 && h>0);
	}

	/**
	 * @param r sW
	 * @param c W
	 * @return Returns the pier.
	 */
	public Pier getPier(int r, int c) {
		return pier[r][c];
	}
	public Pier getPier(Address p) {
		return pier[p.r()][p.c()];
	}

	public Pier setPier(Address p, Pier pi) {
		return pier[p.r()][p.c()] = pi;
	}
	/**
	 * ̃}X̋擾
	 * @param r sW
	 * @param c W
	 * @param dir c̋̋
	 * @return@̃}X̏̋
	 */
	public Bridge getBridge(Address p, int dir) {
		if (dir == Direction.HORIZ) {
			return bridgeH[p.r()][p.c()];
		} else if (dir == Direction.VERT) {
			return bridgeV[p.r()][p.c()];
		}
		return null;
	}
	/**
	 * ̒ʂՏ̊e}XɁC̋ݒ肷
	 * @param pos0 n_}X
	 * @param d n_I_
	 * @param b Bridge
	 */
	void setBridge(Address pos0, int d, Bridge b) {
		Address pos = pos0;
		int dir = d&1;
		while(true) {
			pos = pos.nextCell(d);
			if (isPier(pos))
				break;
			if (dir == Direction.HORIZ) {
				bridgeH[pos.r()][pos.c()] = b;
			} else if (dir == Direction.VERT) {
				bridgeV[pos.r()][pos.c()] = b;
			}
		}
	}

	/**
	 * }Xw肵֏oĂ鋴̐ԂB}XȊOw肵Ƃ -1 Ԃ
	 * @param p }X̍W
	 * @param d 
	 * @return }X炠ւ̖̋{B}XȊOł-1
	 */
	public int getLineFromPier(Address p, int d) {
		if (isPier(p)) {
			return getPier(p).getLine(d);
		} else {
			return -1;
		}
	}

	/**
	 * w肵WɋrVKɍ쐬
	 * ̃}XɂƂƂĂ͏
	 * @param p W
	 * @param n 
	 */
	void addPier(Address p, int n) {
		Pier pi = new Pier(p, n);
		setPier(p, pi);
		for (int d = 0; d < 4; d++) {
			Address nextPos = findPier(p, d);
			if (nextPos == Address.nowhere())
				continue;
			Pier next = getPier(nextPos);
			if (next.getLine(d^2) > 0) {
				changeLine(nextPos, d^2, 0);
			}
		}
		for (int d = 0; d < 4; d++) {
			Address nextPos = findPier(p, d);
			if (nextPos == Address.nowhere())
				continue;
			Pier next = getPier(nextPos);
			next.setNextPier(d^2,pi);
			pi.setNextPier(d,next);
			Bridge b = new Bridge(pi, next);
			next.setBridge(d^2, b);
			pi.setBridge(d, b);
			setBridge(p, d, b);
		}
	}
	/**
	 * w肵Wɂ鋴r
	 * ̋oĂ͏
	 * @param p W
	 */
	void removePier(Address p) {
		Pier pi = getPier(p);
		for (int d=0; d<4; d++) {
			if (getLineFromPier(p, d) > 0) {
				changeLine(p, d, 0);
			}
		}
		for (int d=0; d<4; d++) {
			Pier p1 = pi.getNextPier(d);
			Pier p2 = pi.getNextPier(d^2);
			if (p1 != null) {
				if (p2 != null)
					p1.setNextPier(d^2, p2);
				else
					p1.setNextPier(d^2, null);
			}
		}
		for (int d=0; d<2; d++) {
			Pier p1 = pi.getNextPier(d);
			Pier p2 = pi.getNextPier(d^2);
			if (p1 != null) {
				if (p2 != null) {
					Bridge b = new Bridge(p1, p2);
					setBridge(p2.getPos(), d, b);
					p1.setBridge(d^2, b);
					p2.setBridge(d, b);
				} else {
					setBridge(p, d, null);
					p1.setBridge(d^2, null);
				}
			} else {
				if (p2 != null) {
					setBridge(p, d^2, null);
					p2.setBridge(d, null);
				} else {
				}
			}
		}
		setPier(p, null);
	}

	/**
	 * @return Returns the maxChain.
	 */
	int getMaxChain() {
		return maxChain;
	}

	/**
	 * N_w肵ɂŏ̋̃}X̍WԂ
	 * @param p0 N_̍W
	 * @param direction rT
	 * @return N_w肵ɂŏ̋r
	 */
	Address findPier(Address p0, int direction) {
		Address p = Address.nextCell(p0, direction);
		while (isOn(p)) {
			if (isPier(p)) {
				return p;
			}
			p = p.nextCell(direction);
		}
		return Address.nowhere();
	}
	/**
	 * C
	 * @param p N_̍W
	 * @param d i㉺Ej
	 * @param n ύX̋̐
	 */
	public void changeLine(Address p, int d, int n) {
		if (!isPier(p))
			return;
		if (n < 0 || n > 2)
			return;
		Pier pi = getPier(p);
		Pier nextPier = pi.getNextPier(d);
		if (nextPier == null)
			return;
		int prev = pi.getLine(d);
		if (prev == n)
			return;
		pi.setLine(d, n);
		if (isRecordUndo())
			fireUndoableEditUpdate(new BridgeEditStep(p, d, prev, n));
		if (n == 0)
			cutChain(pi, nextPier);
		if (prev == 0)
			connectChain(pi, nextPier);
	}

	public void undo(AbstractStep step) {
		if (step instanceof BridgeEditStep) {
			BridgeEditStep s = (BridgeEditStep)step;
			changeLine(s.getPos(), s.getDirection(), s.getBefore());
		} else if (step instanceof CellEditStep) {
			CellEditStep s = (CellEditStep)step;
			changeNumber(s.getPos(), s.getBefore());
		}
	}

	public void redo(AbstractStep step) {
		if (step instanceof BridgeEditStep) {
			BridgeEditStep s = (BridgeEditStep)step;
			changeLine(s.getPos(), s.getDirection(), s.getAfter());
		} else if (step instanceof CellEditStep) {
			CellEditStep s = (CellEditStep)step;
			changeNumber(s.getPos(), s.getAfter());
		}
	}

	/**
	 * ̘Aԍ
	 */
	void initChain() {
		for (Address p : cellAddrs()) {
			if (isPier(p)) {
				getPier(p).setChain(0);
			}
		}
		maxChain = 1;
		for (Address p : cellAddrs()) {
			if (isPier(p)) {
				Pier pi = getPier(p);
				if (pi.totalLines() == 0)
					pi.setChain(0);
				else if (pi.getChain() == 0) {
					initChain1(pi, maxChain++);
				}
			}
		}
	}

	/**
	 * }Xn_Ƃ chainԍ̏
	 * @param pi n_ƂȂ鋴r
	 * @param chain ԍ
	 */
	void initChain1(Pier pi, int chain) {
		if (pi.getChain() == chain)
			return;
		pi.setChain(chain);
		for (int d = 0; d < 4; d++) {
			if (pi.getLine(d) > 0)
				initChain1(pi.getNextPier(d), chain);
		}
	}
	/**
	 * chain 
	 * hbOɍ킹
	 * @param pierA
	 * @param pierB
	 */
	void connectChain(Pier pierA, Pier pierB) {
		int a = pierA.getChain();
		int b = pierB.getChain();
		if (a == 0) {
			if (b == 0) {
				pierA.setChain(maxChain);
				pierB.setChain(maxChain);
				maxChain++;
			} else if (b > 0) {
				pierA.setChain(b);
			}
		} else if (a > 0) {
			if (b == 0) {
				pierB.setChain(a);
			} else if (b > 0) {
				initChain1(pierB, a);
			}
		}
	}

	/**
	 * chain ؒf
	 * hbOԍ̔ԍɎc
	 * @param pierA
	 * @param pierB
	 */
	void cutChain(Pier pierA, Pier pierB) {
		int a = pierA.totalLines();
		int b = pierB.totalLines();
		if (a == 0) {
			pierA.setChain(0);
			if (b == 0) {
				pierB.setChain(0);
			} else if (b > 0) {
			}
		} else if (a > 0) {
			if (b == 0) {
				pierB.setChain(0);
			} else if (b > 0) {
				initChain1(pierB, maxChain++);
			}
		}
	}

	/**
	 * ̃}Xo鋴̐ɒBĂ邩ǂׂ
	 * @param p W
	 * @return >0: Ȃ, =0: 傤, <0 
	 */
	public int checkNumber(Address p) {
		Pier pi = getPier(p);
		int number = pi.getNumber();
		int bridges = pi.totalLines();
		if (number == UNDECIDED_NUMBER)
			return 0;
		return number - bridges;
	}

	public int checkAnswerCode() {
		int result = 0;
		if (checkCross() == false)
			result |= 1;
		if (checkConnection() == false)
			result |= 2;
		if (checkNumbers() == false)
			result |= 4;
		return result;
	}

	public String checkAnswerString() {
		int result = checkAnswerCode();
		if (result == 0)
			return BoardBase.COMPLETE_MESSAGE;
		StringBuffer message = new StringBuffer();
		if ((result & 1) == 1)
			message.append(ERR_CROSS_BRIDGE);
		if ((result & 2) == 2)
			message.append(YET_MULTIPLE_LINE);
		if ((result & 4) == 4)
			message.append(ERR_WRONG_NUMBER);
		return message.toString();
	}

	private boolean checkNumbers() {
		for (Address p : cellAddrs()) {
			if (isPier(p)) {
				if (checkNumber(p) != 0) {
					return false;
				}
			}
		}
		return true;
	}

	private boolean checkConnection() {
		int n = 0;
		for (Address p : cellAddrs()) {
			if (isPier(p)) {
				int m = getPier(p).getChain();
				if (m == 0)
					return false;
				else if (n == 0)
					n = m;
				else if (n != m)
					return false;
			}
		}
		return true;
	}

	private boolean checkCross() {
		for (Address p : cellAddrs()) {
			if (hasCrossedBridge(p)) {
				return false;
			}
		}
		return true;
	}

	static final String ERR_CROSS_BRIDGE = Messages.getString("hashi.AnswerCheckMessage1"); //$NON-NLS-1$
	static final String YET_MULTIPLE_LINE = Messages.getString("hashi.AnswerCheckMessage2"); //$NON-NLS-1$
	static final String ERR_WRONG_NUMBER = Messages.getString("hashi.AnswerCheckMessage3"); //$NON-NLS-1$
//	static final String ERR_TOO_MANY_LINE = "̐鐔\n";
//	static final String YET_TOO_FEW_LINE= "̐Ȃ\n";

}
