package pencilbox.kakuro;

import pencilbox.common.core.Address;
import pencilbox.common.core.Direction;

/**
 * \rbgp^[ŕ\qg@\
 */
public class DigitPatternHint {

	private Board board;
	private int[][] horizPattern;
	private int[][] vertPattern;

	/**
	 * ̃}XɔzuĒڂ̃[ᔽɂȂȂ̃rbgp^[ԂB
	 * @param p }X̍W
	 * @return \ȃrbgp^[ԂB̃}Xǃ}Xł邩܂̓^eR̗Ƃa`ĂȂꍇ͒l 1 ԂB
	 */
	int getPattern(Address p) {
		int pat = horizPattern[p.r()][p.c()] & vertPattern[p.r()][p.c()];
		// ς̍ŉʃrbg 1 ł΃^eRƂ`ƂƂȂ̂ŁC\Ȃ߂ 1 ԂB
		// ^eRƂ`̏ꍇ 1`9@܂łׂĉ\Ƃhbg\ꍇ͈ȉ2s폜B
		if ((pat & 1) == 1)
			return 1;
		return pat;
	}

	void setupHint(Board board) {
		this.board = board;
		horizPattern = new int[board.rows()][board.cols()];
		vertPattern = new int[board.rows()][board.cols()];
	}

	/**
	 * ̍W̐ύXꂽƂɁC̃}X܂ރ^eRČvZ
	 * @param p
	 */
	void updatePattern(Address p) {
		updatePattern(p, Direction.HORIZ);
		updatePattern(p, Direction.VERT);
	}

	/**
	 * W̃}X܂ރR܂̓^ẽ[h̔zu\p^[߂B
	 * @param p0
	 * @param dir
	 */
	void updatePattern(Address p0, int dir) {
		int pattern = 0;
		Address headPosition = board.getWordHead(p0, dir);//̃}X܂ސ̘a}X̗W
		int wordSum = board.getWordSum(p0, dir); // ̘a
		int wordSize = board.getWordSize(p0, dir); //@}X
		int currentSum = 0;// ςݐ̘a
		int currentSize = 0; // ςݐ̐
		int usedDigit = 0;// gpςݐ̃p^[
		Address p = headPosition;
		if (wordSum == 0) { // a`ĂȂ΂ׂĉ\
			pattern = HintTbl.D_ALL + 1;
		} else if (wordSize > 9) {
			pattern = 0;
		} else {
			for (int i = 0; i < wordSize; i++) {
				p = Address.nextCell(p, dir|2);
				int n = board.getNumber(p);
				if (n > 0) {
					currentSize++;
					currentSum += n; // aɉZ
					usedDigit |= (1 << n);//gpĂ鐔
				}
			}
			if (currentSize == wordSize) { // ׂČ܂Ă
				pattern = 0;
			} else {
				pattern = HintTbl.getRemainingDigit(wordSum - currentSum, wordSize - currentSize, usedDigit);
			}
		}
		for (int i = 0; i < wordSize; i++) {
			if (dir == Direction.HORIZ)
				horizPattern[p0.r()][headPosition.c()+1+i] = pattern;
			else if (dir == Direction.VERT)
				vertPattern[headPosition.r()+1+i][p0.c()] = pattern;
		}
	}

	/**
	 * ՖʑŜ̉\p^[ČvZ
	 */
	void initHint() {
		// SČvẐŁAS\Ƃ
		for (Address p : board.cellAddrs()) {
			vertPattern[p.r()][p.c()] = HintTbl.D_ALL + 1;
			horizPattern[p.r()][p.c()] = HintTbl.D_ALL + 1;
		}
		for (Address p : board.cellAddrs()) {
			if (board.isWall(p)) {
				for (int d = 0; d < 2; d++) {
					Address p1 = Address.nextCell(p, d|2);
					if (!board.isWall(p1));
						if (board.getSum(p, d) > 0) {
							updatePattern(p1, d);
						}
				}
			}
		}
	}
}
