/* rc-apple.c - Keytable for Apple remotes
 *
 * Copyright (c) 2011 by Jarod Wilson <jarod@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <media/rc-map.h>

/*
 * The Apple remotes use an NEC-ish protocol, but instead of having a
 * command/not_command pair, they use a vendor ID of 0x77e1. Another byte
 * is used for a pairing ID (0-255), to make it possible to have a system
 * listen for only its specific remote. The last byte is the actual command
 * byte. This table will only Just Work(tm) with remotes that have their
 * pairing byte set to 0xc7 at the moment (one of my Apple remotes), but
 * it can be trivially replaced from userspace with one using a different
 * pairing byte value.
 */
static struct rc_map_table apple[] = {
	{ 0x77e150c7, KEY_VOLUMEUP },
	{ 0x77e130c7, KEY_VOLUMEDOWN },
	{ 0x77e190c7, KEY_REWIND },
	{ 0x77e160c7, KEY_FASTFORWARD },
	{ 0x77e1a0c7, KEY_PLAYPAUSE },
	{ 0x77e1c0c7, KEY_MENU },
};

static struct rc_map_list apple_map = {
	.map = {
		.scan    = apple,
		.size    = ARRAY_SIZE(apple),
		.rc_type = RC_TYPE_NEC,
		.name    = RC_MAP_APPLE,
	}
};

static int __init init_rc_map_apple(void)
{
	return rc_map_register(&apple_map);
}

static void __exit exit_rc_map_apple(void)
{
	rc_map_unregister(&apple_map);
}

module_init(init_rc_map_apple)
module_exit(exit_rc_map_apple)

MODULE_LICENSE("GPL");
MODULE_AUTHOR("Jarod Wilson <jarod@redhat.com>");
