/*
Copyright Isamu.Yamauchi 2013-2015. update 2013.9.5
This program uses the libpiface. thanks.
pepopiface.c is controls for Raspberry pi PiFace Digital I/O Expansion Board

o 2013.07.20 1st release.
o 2013.9.5 to match the input state of piface, modified to highlight the port data.

*/

/*
This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include <libpiface-1.0/pfio.h>
#define READ     'R'
#define WRITE    'W'
#define VER "0.2"
#define DAY "compiled:"__DATE__
void usage() {
  fprintf(stderr,"\r\n** Welcome to pepopiface Version-%s Copyright Yamauchi.Isamu %s **",VER,DAY);
  fprintf(stderr,"\n\rusage:pepopiface port:0-8 [0|1] [timer:0-65535ms]\n\r");
}

int msleep(int ms) {
  if ( ms > 0 ) {
    struct timeval timeout;
    timeout.tv_sec = ms / 1000;
    timeout.tv_usec = (ms % 1000) * 1000;
    if (select(0, (fd_set *) 0, (fd_set *) 0, (fd_set *) 0, &timeout) < 0) {
      perror("msleep");
      return 1;
    }
  }
  return 0;
}

int main(int argc, char *argv[]) {
  int port = 0;
  int data = 0;
  int invert_data = 0;
  int wait_time = 5;
  int port_timer = 0;
  char rw_flag = READ;
  int i = 0x0000;
  int j = 0x0000;
  int result = 0;
  char patterns[] = {0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80};
  if ( argc > 4 || argc < 2  ) {
    usage();
    exit(1);
  }
  else {
    port = atoi(argv[1]); 
    if ( port > 8 || port < 0 ) {
      usage();
      exit(1);
    }
  }
  
  if ( argc == 3 ||  argc == 4) {
    data = atoi(argv[2]);
    if ( data != 0 && data != 1 ) {
      usage();
      exit(1);
    }
    else {
      rw_flag = WRITE;
    }
  }
  if ( argc == 4 ) {
    port_timer = atoi(argv[3]);
    if ( port_timer < 0 || port_timer > 65535 ) {
      usage();
      exit(1);
    }
    rw_flag = WRITE;
  }    
  if (pfio_init() < 0) exit(-1);
  msleep(wait_time);
  if ( rw_flag == WRITE ) {
// port write
    pfio_digital_write(port, data);
    if ( port_timer > 0 ) {
      if ( data == 0 ) {
        invert_data = 1;
      }
      else {
        invert_data = 0;
      }
      msleep(port_timer);
      pfio_digital_write(port, invert_data);
    }
    result = pfio_read_output() && patterns[port];
    fprintf(stderr,"%d",result);
  }
  if ( rw_flag == READ ) {
// port read
    if ( port == 8 ) {
	  i = pfio_read_input() & 0xffff;
	  j = pfio_read_output() << 8;
          j = j & 0xffff;
          i = i ^ 0xffff;
          i = i & 0x00ff;
	  result = j | i;
      fprintf(stderr,"%04x",result);
    }
    else {
      result = pfio_read_input() && patterns[port];
      result = result ^ 1;
      fprintf(stderr,"%d",result);
    }
  }
  msleep(wait_time);
  pfio_deinit();
  exit(0);
}
