/*
 * BDF2BDB - BDF font data conveter
 * Release version 0.0.0
 * Copyright (c)2006 satoshi akabane
 * http://www.logical-paradox.org/
 *
 * The MIT License
 * Copyright (c) 2006 satoshi akabane(akabane@logical-paradox.org)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights 
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#ifndef __bdb_h__
#define __bdb_h__

#include <stdio.h>
#include <stdlib.h>
#include "bdf2bdb.h"


/*
 * declaration of BDB file structure.
 */
typedef struct FONT {
	char start_char[4];								/* ascii code (4 bytes - 32-bit) */
	char encoding[4];								/* encoding (4 bytes - 32-bit) */
	char swidth[2][4];								/* swidth 2 args by 32-bit number */
	char dwidth[2][4];								/* dwidth 2 args by 32-bit number */
	char bbx[4][4];									/* bbx 4 args by 4 signed 8-bit number */
	int bitmap_count;								/* bitmap storing counter */
	char *bitmap;									/* ptr. of bitmap */
} FONT;

typedef struct BDB {
	char magic_number[4];							/* magic number */
	char major_version;								/* major version number */
	char minor_version;								/* minor version number */
	char pixel_size;								/* pixel size */
	char high_dpi;									/* high resolution point num. */
	char low_dpi;									/* low resolution point num. */
	char font_bounding_box_width;					/* font-bounding-box (width) */
	char font_bounding_box_height;					/* font-bounding-box (height) */
	char font_bounding_box_horizon_offset;			/* font-bounding-box (horizontal offset) */
	char font_bounding_box_vertical_offset;			/* font-bounding-box (vertical offset) */
	char chars[4];									/* defined font characters (4 bytes - 32-bit) */
	int  font_count;								/* font counts */
	int  scanning_bitmap;							/* scanning bitmap (0: none / 1: processing) */
	FONT *font;										/* pointer of font description block */
} BDB;

/*
 * KEYWORDS and pointer of their handlers.
 */
typedef struct KEYWORD {
	char* keyword;
	int (*func)(int, char **, BDB *);
} KEYWORD;


/* prototype declarations */
BDB *new_bdb();
void delete_bdb(BDB *bdb);
int parser(char *ptr, BDB *bdb);
int evaluate_expression(int num_of_tokens, char **tokens, BDB *bdb);
KEYWORD *search_keyword_blk(char *token);
void output_bdb(const char *filename, BDB *bdb);

/*
 * parser error code.
 */
#define PSRERR_NO_ERROR		(0)

#endif
