/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: PutitBasicApplet.java,v 1.1 2006/04/06 09:08:10 akabane Exp $
 */
package org.logical_paradox.petitbasic.gui;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;

import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

/**
 * v`BASICAvbgD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class PetitBasicApplet extends JApplet {
	/** suid */
	private static final long serialVersionUID = -7084052188818938094L;
	/** AvbgƂċNꂽǂ */
	private boolean runAsApplet = true;
	/** GUIRtBO */
	private PetitBasicGuiConfig config;

	/**
	 * Avbg̏R[hD
	 */
	public void init() {
		super.init();
		Container container = null;

		// RtBO[V̍쐬
		ResourceBundle resource = ResourceBundle.getBundle("petitbasic_gui");
		config = new PetitBasicGuiConfig(resource);

		if(runAsApplet == true) {
			// AvbgƂē삵Ăꍇ
			container = getContentPane();
			initApplication(container);
		} else {
			// X^hA[AvP[VƂē삵Ăꍇ
			JFrame mainFrm = new JFrame();
			container = mainFrm.getContentPane();
			initApplication(container);

			// EBhE̕\ʒuƃTCY̒
			int width = config.getWindowWidth() + PetitBasicGuiConfig.FONTSIZE_PX_W + PetitBasicGuiConfig.FONTSIZE_PX_W;
			int height = config.getWindowHeight() + PetitBasicGuiConfig.FONTSIZE_PX_H + PetitBasicGuiConfig.FONTSIZE_PX_H;
			Dimension windowLocation = Toolkit.getDefaultToolkit().getScreenSize();
			mainFrm.setLocation(((int)windowLocation.getWidth() - width) /2, ((int)windowLocation.getHeight() - height) /2);
			mainFrm.setSize(new Dimension(width, height));
			mainFrm.setVisible(true);
			mainFrm.setResizable(false);

			mainFrm.addWindowListener(new WindowAdapter() {
					public void windowClosing(WindowEvent e) {
						System.exit(0);
					}
				}
			);
		}
	}
	/**
	 * x[XReiɁCGUIR|[lgzuĉʂ쐬D
	 * @param baseContainer x[XRei
	 */
	public void initApplication(Container baseContainer) {
		// eLXg̓tB[h1邾Ƃ
//		JTextPane textpane = new JTextPane();
//		DefaultStyledDocument doc = new DefaultStyledDocument();
//		textpane.setStyledDocument(doc);
//		textpane.setDocument(doc);
//
//		SimpleAttributeSet attr = new SimpleAttributeSet();
//
//		StyleConstants.setForeground(attr, config.getWindowForecolor());
//		StyleConstants.setFontFamily(attr, "monospaced");
//		StyleConstants.setFontSize(attr, 16);
////		StyleConstants.setLineSpacing(attr, -0.3f);
////		textpane.setParagraphAttributes(attr, true);
//		textpane.setFont(new Font("monospaced", Font.PLAIN, 16));
//		textpane.setForeground(config.getWindowForecolor());
//		textpane.setBackground(config.getWindowBgcolor());
//		textpane.setText("123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*PQRSPQRSPQRSPQRSPQRSPQRSPQRSPQRSPQRSPQRSPQRSPQRS");

		JPanel compo = new JPanel() {
			public void paint(Graphics g) {
				String str = "123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*PQRSPQRSPQRSPQRSPQRSPQRSPQRSPQRSPQRSPQRSPQRSPQRS";
				Color current = g.getColor();
				g.setColor(Color.WHITE);
				g.setFont(new Font("monospaced", Font.PLAIN, 16));
				g.drawString(str, 0, 16);
				g.setColor(current);
			}
		};
		baseContainer.setLayout(new BorderLayout());
		baseContainer.add(compo, BorderLayout.CENTER);
		baseContainer.validate();
	}
	/**
	 * C\bhD
	 * X^hA[ŋNꍇC̃\bhJnD
	 * @param args vO 
	 * @throws Exception ȂO
	 */
	public static final void main(String[] args) throws Exception {
		PetitBasicApplet applet = new PetitBasicApplet();
		applet.runAsApplet = false;
		applet.init();
	}
}
