/*
 * $Id: Cursor.java,v 1.6 2008/10/08 18:23:46 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.gui;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

/**
 * J[\D
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.6 $
 */
public class Cursor {
	/** J[\` - ㏑[h */
	public static final int CS_OVERWRITE = 1;
	/** J[\` - } */
	public static final int CS_INSERT = 2;

	/** GUI^C */
	private final PetitBasicGuiRuntimeEnv env;
	/** J[\\(true:\ / false:\) */
	private boolean shown = false;
	/** J[\` */
	private int style = CS_OVERWRITE;

	/**
	 * RXgN^D
	 * @param e ^C
	 */
	public Cursor(PetitBasicGuiRuntimeEnv e) {
		env = e;
	}
	/**
	 * J[\\D
	 */
	public void show() {
		shown = true;
	}
	public void show(BufferedImage g) {
		turn(g);
	}
	/**
	 * J[\\ɂD
	 */
	public void hide() {
		shown = false;
	}
	/**
	 * J[\̕\Ԃ؂ւD
	 * @param bi 摜obt@
	 */
	protected void turn(BufferedImage bi) {
		int pitchX = env.fontDriver.getFontWidth();
		int pitchY = env.fontDriver.getFontHeight();
		int styleOffset = style == CS_INSERT ? pitchY / 2 : 0;
		DataBufferInt dbi = (DataBufferInt)bi.getRaster().getDataBuffer();
		int[] buf = dbi.getData();
		Color forecolor = env.config.getWindowForecolor();
		Color bgcolor = env.config.getWindowBgcolor();
		String fc = forecolor.toString();
		int hz = env.display.getHorizonSize();
		int yy = env.cursorYpos * pitchY;

		for(int y = yy + styleOffset; y < yy + pitchY; y++) {
			int xx = env.cursorXpos * pitchX;
			int pos = y * hz + xx;

			for(int cnt = 0; cnt < pitchX; cnt++) {
				int d = buf[pos];
				String bc = new Color(d).toString();
				
				if(!fc.equals(bc)) {
					buf[pos] = forecolor.getRGB();
				} else {
					buf[pos] = bgcolor.getRGB();
				}
				
				pos++;
			}
		}
	}
	/**
	 * J[\̕\ԂԂD
	 * @return true:\ / false:\
	 */
	public boolean isShown() {
		return shown;
	}
	/**
	 * J[\`ݒ肷D
	 * @param i J[\`(CS_OVERWRITE: ㏑[h / CS_INSERT: }[h)
	 */
	public void setStyle(int i) {
		style = i;
	}
	/**
	 * J[\̌`ԂB
	 * @return J[\̌`
	 * @see #CS_INSERT
	 * @see #CS_OVERWRITE
	 */
	public int getStyle() {
		return style;
	}
}
