/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: PetitBasicGuiConfig.java,v 1.13 2008/10/08 18:23:46 akabane Exp $
 */
package org.logical_paradox.petitbasic.gui;

import java.awt.Color;
import java.util.MissingResourceException;
import java.util.Properties;

/**
 * v`BASIC GUIRtBO[VD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.13 $
 */
public class PetitBasicGuiConfig {
	/** tHgTCY(px)  */
	public static final int FONTSIZE_PX_W = 8;
	/** tHgTCY(px)  */
	public static final int FONTSIZE_PX_H = 16;

	/** vpeBL[ - n[hEFA^C}[Ԋu */
	public static final String PKEY_PB_HW_TIMER = "pb.hw.timer";
	/** vpeBL[ - PSCI */
	public static final String PKEY_PB_HW_PSCI = "pb.hw.psci";
	/** vpeBL[ - VSYNC */
	public static final String PKEY_PB_HW_VSYNC = "pb.hw.vsync";
	/** vpeBL[ - \\ */
	public static final String PKEY_PB_CHARS_HORIZON_MAX = "pb.chars.horizon.max";
	/** vpeBL[ - c\\ */
	public static final String PKEY_PB_CHARS_VERICAL_MAX = "pb.chars.verical.max";
	/** vpeBL[ - EBhEOiF */
	public static final String PKEY_PB_WINDOW_FORECOLOR = "pb.window.forecolor";
	/** vpeBL[ - EBhEwiF */
	public static final String PKEY_PB_WINDOW_BGCOLOR = "pb.window.bgcolor";
	/** vpeBL[ - EBhETCY() */
	public static final String PKEY_PB_WINDOW_HORIZON = "pb.window.horizon";
	/** vpeBL[ - EBhETCY(c) */
	public static final String PKEY_PB_WINDOW_VERTICAL = "pb.window.vertical";
	/** vpeBL[ - tHgt@C */
	public static final String PKEY_PB_FONT_FILENAME = "pb.font.filename";
	/** vpeBL[ - t@NVL[ݒ */
	public static final String PKEY_PB_KEY = "pb.key";
	/** vpeBL[ - J[pbgݒ */
	public static final String PKEY_PB_COLOR_PALLET = "pb.color";
	/** vpeBL[ - XvCg`\ */
	public static final String PKEY_SPRITE_DECL_MAX = "pb.sprite.decl.max";
	/** vpeBL[ - XvCg\\ */
	public static final String PKEY_SPRITE_DISP_MAX = "pb.sprite.disp.max";
	/** J[pbg̍ő`\ */
	public static final int MAX_COLOR_PALETTES = 16;

	/** n[hEFA^C}[ */
	private int hardwareTimer = -1;
	/** PSCI */
	private int psci = -1;
	/** VSYNC */
	private int vsync = -1;
	/** \̈̉TCY */
	private int windowHorizonSize;
	/** \̈̏cTCY */
	private int windowVerticalSize;
	/** \\ */
	private int charsHorizonMax;
	/** c\\ */
	private int charsVerticalMax;
	/** EBhEOiF(J[R[h) */
	private int windowForecolor;
	/** EBhEwiF(J[R[h) */
	private int windowBgcolor;
	/** rbg}bvtHgt@C */
	private String fontfile;
	/** t@NVL[̕\(true:\ / false:\) */
	public boolean functionKeyDisplay = true;
	/** t@NVL[̕\(false:F1`F6 / true:F7`F12) */
	public boolean functionKeyDisplayShift = false;
	/** őt@NVL[` */
	public static final int MAX_FUNCTION_KEY_SETS = 12;

	/** t@NVL[̐ݒ */
	public final String[] functionKeyStrings = new String[MAX_FUNCTION_KEY_SETS];
	/** J[pbg() */
	public final Color[] colorPallet = new Color[MAX_COLOR_PALETTES];
	/** J[pbg(l) */
	public final Color[] colorPalletDefault = new Color[MAX_COLOR_PALETTES];

	/** XvCg`\ */
	private int spriteDeclMaxCount = 0;
	/** XvCg\\ */
	private int spriteDispMaxCount = 0;

	/**
	 * RXgN^D
	 * @param pp vpeB
	 */
	public PetitBasicGuiConfig(Properties pp) {
		init(pp);
	}
	/**
	 * RtBO[V\zD
	 * @param pp vpeB
	 */
	protected void init(Properties pp) {
		charsHorizonMax = Integer.parseInt(pp.getProperty(PKEY_PB_CHARS_HORIZON_MAX));
		charsVerticalMax = Integer.parseInt(pp.getProperty(PKEY_PB_CHARS_VERICAL_MAX));
		windowHorizonSize = Integer.parseInt(pp.getProperty(PKEY_PB_WINDOW_HORIZON));
		windowVerticalSize = Integer.parseInt(pp.getProperty(PKEY_PB_WINDOW_VERTICAL));

		fontfile = pp.getProperty(PKEY_PB_FONT_FILENAME);

		// ftHg̃t@NVL[ݒ[h
		for(int i = 1; i <= functionKeyStrings.length; i++) {
			String key = PKEY_PB_KEY + "." + i;
			String value = "";
			try {
				value = pp.getProperty(key);
			} catch(MissingResourceException e) {
				// 
			}
			functionKeyStrings[i-1] = value;
		}
		// J[pbg̐ݒ[h
		for(int i = 0; i < colorPalletDefault.length; i++) {
			String key = PKEY_PB_COLOR_PALLET + "." + i;
			String value = "255,255,255";
			try {
				value = pp.getProperty(key);
			} catch(MissingResourceException e) {
				// 
			}
			String[] elements = value.split(",");
			Color color = null;
			color = new Color(
						Integer.parseInt(elements[0].trim()),
						Integer.parseInt(elements[1].trim()),
						Integer.parseInt(elements[2].trim())
					);
			colorPalletDefault[i] = color;
			colorPallet[i] = color;
		}

		// OiF
		windowForecolor = Integer.parseInt(pp.getProperty(PKEY_PB_WINDOW_FORECOLOR).trim());
		// wiF
		windowBgcolor = Integer.parseInt(pp.getProperty(PKEY_PB_WINDOW_BGCOLOR).trim());
		// n[hEFA^C}[
		hardwareTimer = Integer.parseInt(pp.getProperty(PKEY_PB_HW_TIMER).trim());
		// PSCI
		psci = Integer.parseInt(pp.getProperty(PKEY_PB_HW_PSCI).trim());
		// VSYNC
		vsync = Integer.parseInt(pp.getProperty(PKEY_PB_HW_VSYNC).trim());
		// XvCg`\
		spriteDeclMaxCount = Integer.parseInt(pp.getProperty(PKEY_SPRITE_DECL_MAX).trim());
		// XvCg\\
		spriteDispMaxCount = Integer.parseInt(pp.getProperty(PKEY_SPRITE_DISP_MAX).trim());
	}
	/**
	 * \\ԂD
	 * @return \\
	 */
	public int getCharsHorizonMax() {
		return charsHorizonMax;
	}

	/**
	 * c\\ԂD
	 * t@NVL[̕\ԂɉlԂD
	 * @return c\\
	 */
	public int getCharsVerticalMax() {
		return charsVerticalMax - (functionKeyDisplay ? 1 : 0);
	}
	/**
	 * c\\ԂD
	 * @return c\\
	 */
	public int getCharsVerticalMaxActual() {
		return charsVerticalMax;
	}
	/**
	 * wiFԂ.
	 * @return wiF
	 */
	public Color getWindowBgcolor() {
		return colorPallet[windowBgcolor];
	}
	/**
	 * wiFJ[R[hŕԂ.
	 * @return wiF
	 */
	public int getWindowBgcolorCode() {
		return windowBgcolor;
	}
	/**
	 * wiFJ[R[hŐݒ肷.
	 * @param color J[R[h
	 */
	public void setWindowBgcolorCode(int cc) {
		windowBgcolor = cc;
	}
	/**
	 * OiFԂ.
	 * @return OiF
	 */
	public Color getWindowForecolor() {
		return colorPallet[windowForecolor];
	}
	/**
	 * OiFJ[R[hŕԂ.
	 * @return OiF
	 */
	public int getWindowForecolorCode() {
		return windowForecolor;
	}
	/**
	 * OiFJ[R[hŐݒ肷.
	 * @param cc J[R[h
	 */
	public void setWindowForecolorCode(int cc) {
		windowForecolor = cc;
	}
	/**
	 * w肵FɑΉJ[R[hԂ.
	 * @param rgb F
	 * @return J[R[h(-1:YȂ)
	 */
	public int getColorCode(int rgb) {
		for(int i = 0; i < colorPallet.length; i++) {
			if(rgb == (colorPallet[i].getRGB() & 0x00ffffff)) {
				return i;
			}
		}
		
		return -1;
	}
	/**
	 * EBhẺTCYԂD
	 * @return EBhẺTCY
	 */
	public int getWindowWidth() {
		return windowHorizonSize;
	}

	/**
	 * EBhȄcTCYԂD
	 * @return EBhȄcTCY
	 */
	public int getWindowHeight() {
		return windowVerticalSize;
	}
	
	/**
	 * rbg}bvtHgt@CԂD
	 * @return rbg}bvtHgt@C
	 */
	public String getFontFilename() {
		return fontfile;
	}

	/**
	 * n[hEFA^C}[̊ԊuԂD
	 * @return hardwareTimer n[hEFA^C}[̊Ԋu(PʁFNbN)
	 */
	public int getHardwareTimer() {
		return hardwareTimer;
	}
	/**
	 * XvCg`\ԂD
	 * @return XvCg`\
	 */
	public int getSpriteDeclMaxCount() {
		return spriteDeclMaxCount;
	}
	/**
	 * XvCg\\ԂD
	 * @return XvCg\\
	 */
	public int getSpriteDispMaxCount() {
		return spriteDispMaxCount;
	}
	/**
	 * PSCI荞݊ԊuԂ
	 * @return PSCI荞݊Ԋu
	 */
	public int getPSCI() {
		return psci;
	}
	/**
	 * VSYNC荞݊ԊuԂB
	 * @return VSYNC荞݊Ԋu
	 */
	public int getVSYNC() {
		return vsync;
	}
}
