/*
 * $Id: PetitBasicGuiRuntimeExtention.java,v 1.3 2008/09/28 15:25:45 akabane Exp $
 */
package org.logical_paradox.petitbasic.gui;

import java.util.Stack;

import org.logical_paradox.petitbasic.builtin.syntax.Gosub;
import org.logical_paradox.petitbasic.builtin.syntax.GosubReturnContext;
import org.logical_paradox.petitbasic.gui.ext.On;
import org.logical_paradox.petitbasic.gui.ext.Sprite;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.PetitBasicRuntimeExtension;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.runtime.exception.ExecutionBreakException;
import org.logical_paradox.petitbasic.runtime.exception.FlowControlException;

/**
 * PetitBASIC GUI^CgB
 * @author satoshi akabane@logical-paradox.org
 * @version $revision$
 */
public class PetitBasicGuiRuntimeExtention implements PetitBasicRuntimeExtension {
	/** PetitBASIC GUI^C */
	private final PetitBasicGuiRuntimeEnv env;

	/**
	 * RXgN^B
	 * @param env PetitBASIC GUI^C
	 */
	public PetitBasicGuiRuntimeExtention(PetitBasicGuiRuntimeEnv env) {
		this.env = env;
	}
	/**
	 * PetitBASIC^C߂1OɋNtbNB
	 * @param ctx BASIC^CReLXg
	 * @throws BasicLanguageException BASICG[
	 */
	public void preExecution(BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		/*
		 * CTRL+CĂ邩ǂ̃`FbN
		 */
		if(ctx.breakFlag == true) {
			// vO̎s𒆒f
			throw new ExecutionBreakException();
		}
		
		/*
		 * XvCgՓˊ荞ݔ
		 */
		if(env.vdp.spEngine.isConflicted()) {
			// XvCgmՓ˂Ă
			// ON SPRITE GOSUB̏邱
			int intmod = Sprite.interrupt;

			if(intmod == Sprite.INT_ON) {
				// XvCgՓˊ荞݂ĂꍇCwsֈړ
				Stack calling = ctx.getCallingStructureContext(Gosub.CTXKEY_GOSUB_STACK);
				// ߂̍쐬(݈ʒűL^)
				GosubReturnContext gosubContext = new GosubReturnContext();

				gosubContext.lineno = line.getLineno();
				gosubContext.runptr = line.getRunPtr();
				gosubContext.reason = On.REASON_SPRITE_INTERRUPT;

				// Ăяo\ReLXgɕۑ
				calling.push(gosubContext);

				// XvCgՓˊ荞݂ꎞ~
				Sprite.interrupt = Sprite.INT_STOP;
	
				throw new FlowControlException(Sprite.lineno);
			}
		}
	}

}
