/*
 * $Id: CookieFileSystem.java,v 1.7 2008/09/28 15:53:31 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.gui.bios;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

import netscape.javascript.JSException;
import netscape.javascript.JSObject;

import org.logical_paradox.common.io.ExpandableBuffer;
import org.logical_paradox.common.util.StringUtils;
import org.logical_paradox.petitbasic.fs.PetitBasicFileSystem;
import org.logical_paradox.petitbasic.fs.PetitBasicFilenameFilter;

/**
 * COOKIEt@CVXeD<br/>
 * COOKIEf[^̈Ƃt@CVXeD
 * <pre>
 * +00 (.1b) t@CGg
 * +03 (.2b) t@CTCY
 * +05 (.6b) t@C
 * :
 * []
 * ͑S84iŋL^D
 * 84íCSĕ\\ASCIILN^łD
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.7 $
 */
public class CookieFileSystem extends PetitBasicFileSystem implements FileCloseEventListener {
	/** (10+26+26+22) = 84i */
	private static final String NUMBER_CHARS =
								"0123456789" +					// 10
								"ABCDEFGHIJKLMNOPQRSTUVWXYZ" +	// 26
								"abcdefghijklmnopqrstuvwxyz" +	// 26
								"_!#$%&'`@{}[].,<>?/|^-";		// 22 
	/** t@CGg(L[:t@C / l:t@CGg) */
	private HashMap fileEntry = new HashMap();
	/** Avbg */
	private JSObject jso;

	/**
	 * RXgN^.
	 *
	 */
	public CookieFileSystem() {
		
	}
	/**
	 * t@CVXe.
	 * @param jso EBhE
	 */
	public void init(JSObject jso) {
		this.jso = jso;

		try {
			JSObject doc = (JSObject)this.jso.getMember("document");
			String cookie = (String)doc.getMember("cookie");
			
			setCookie(cookie);
		} catch(JSException e) {
			// uEUNĂȂ̂ŁCcookieɃANZXłȂ
			System.out.println("uEUNĂȂ߁CCOOKIEɂSAVE/LOADgpł܂");
		}
	}
	/**
	 * wt@Cɑ΂o̓Xg[ԂD
	 * @param filename t@C
	 * @return o̓Xg[
	 * @throws IOException t@CȂȂ
	 */
	protected OutputStream getOutputStream(String filename) throws IOException {
		CookieOutputStream out = new CookieOutputStream(filename);
		out.setFileCloseEventListener(this);

		return out;
	}
	/**
	 * wt@Cɑ΂̓Xg[ԂD
	 * @param filename t@C
	 * @return ̓Xg[
	 * @throws IOException t@CȂȂ
	 */
	protected InputStream getInputStream(String filename) throws IOException {
		filename = filename.trim().toUpperCase();
		if(filename.length() > 6) {
			// t@Cꍇ́C6ɃJbg
			filename = filename.substring(0, 6);
		}
		FileEntry fe = (FileEntry)fileEntry.get(filename);
		if(fe == null) {
			// w肳ꂽt@C݂Ȃ
			throw new FileNotFoundException(filename);
		}
		byte[] data = fe.getData().getBytes();
		
		return new ByteArrayInputStream(data);
	}
	/**
	 * wp^[ɍvt@C.
	 * @param filespec t@CXybN
	 * @return t@C̃Xg
	 */
	public String[] searchFileEntry(String filespec) {
		// CookieFileSystemɂdir̊TOȂ
		File dir = new File(".");
		
		// CookieFileSystemł́C啶̋ʂȂ(ӖȂ)
		PetitBasicFilenameFilter filter = new PetitBasicFilenameFilter(filespec.toUpperCase());
		List filenames = new ArrayList();

		// OŃt@CtB^sāC}b`OƂs
		for(Iterator it = fileEntry.keySet().iterator(); it.hasNext();) {
			String filename = it.next().toString().trim().toUpperCase();
			if(filter.accept(dir, filename)) {
				filenames.add(filename);
			}
		}
		
		return (String[])filenames.toArray(new String[0]);
	}
	/**
	 * wp^[ɍvt@C폜.
	 * @param filespec t@CXybN
	 * @return true:폜 / false:폜łȂ
	 * @throws FileNotFoundException 폜Ώۂ̃t@C݂Ȃ
	 */
	public boolean deleteFileEntry(String filespec) throws FileNotFoundException {
		String[] deleteTargets = searchFileEntry(filespec);

		if(deleteTargets == null || deleteTargets.length == 0) {
			throw new FileNotFoundException();
		}
		
		// t@CGg̍폜
		for(int i = 0; i < deleteTargets.length; i++) {
			if(fileEntry.remove(deleteTargets[i]) == null) {
				System.out.println("폜s:" + deleteTargets[i]);
			}
		}
		
		// cookie̕ۑ
		updateCookie();

		return true;
	}
	/**
	 * t@CGg̓eCOOKIEƂĎ擾.
	 * @return COOKIE
	 */
	protected String getCookie() {
		List list = new ArrayList(fileEntry.values());
		FileEntry[] fes = (FileEntry[])list.toArray(new FileEntry[0]);
		
		String cookie = "v=" + escapeCookie(serialize(fes)) + ";expires=Tue, 1-Jan-2030 00:00:00 GMT;";
		
		return cookie;
	}
	/**
	 * COOKIEt@CGgWJ.
	 * @param cookie COOKIE
	 */
	protected void setCookie(String cookie) {
		// COOKIEݒ肳ĂȂꍇ͉Ȃ
		if(StringUtils.isEmpty(cookie)) {
			return;
		}

		cookie = cookie.split(";expire")[0];
		cookie = cookie.substring(2);

		FileEntry[] fes = deserialize(unescapeCookie(cookie));
		
		for(int i = 0; i < fes.length; i++) {
			fileEntry.put(fes[i].getFilename(), fes[i]);
		}
	}
	/**
	 * VAꂽSt@CGg𕜌.
	 * @param cookie VAꂽt@CGg
	 * @return WJꂽt@CGg
	 */
	protected FileEntry[] deserialize(String value) {
		int files = toNumber("" + value.charAt(0));
		FileEntry[] fes = new FileEntry[files];
		int[] filesize = new int[fes.length];

		for(int i = 0; i < fes.length; i++) {
			int pos = 1 + i * 8;		// 1 + (2+6)
			filesize[i] = toNumber(value.substring(pos, pos + 2));				// t@CTCY
			String filename = value.substring(pos+2, pos + 2 + 6).trim();		// t@C
			fes[i] = new FileEntry(filename, null);
		}
		
		// f[^̈̐擪
		int dpos = 1 + files * 8;

		// f[^̎荞
		for(int i = 0; i < fes.length; i++) {
			fes[i].setData(value.substring(dpos, dpos + filesize[i]));
			dpos += filesize[i];
		}

		return fes;
	}
	/**
	 * St@CGg̓eVA.
	 * @param fileEntries t@CGg
	 * @return VAꂽf[^
	 */
	protected String serialize(FileEntry[] fileEntries) {
		StringBuffer sb = new StringBuffer();
		StringBuffer dat = new StringBuffer();

		// t@C
		sb.append(toNumberString(fileEntries.length, 1));

		// t@C
		for(int i = 0; i < fileEntries.length; i++) {
			FileEntry fe = fileEntries[i];
			String filename = null;
			
			if(fe.getFilename().length() > 6) {
				filename = fe.getFilename().substring(0, 6);
			} else {
				filename = StringUtils.resize(fe.getFilename(), 6);
			}
			
			// t@CTCY
			sb.append(toNumberString(fe.getData().length(), 2));
			// t@C
			sb.append(filename);

			dat.append(fe.getData());
		}
		
		// f[^ubN̘A
		sb.append(dat);

		return sb.toString();
	}
	/**
	 * 𐮐ɕϊ.
	 * @param nstr 
	 * @return 
	 */
	protected int toNumber(String nstr) {
		int num = 0;
		char[] ncs = nstr.toCharArray();
		
		for(int i = 0; i < ncs.length; i++) {
			num *= NUMBER_CHARS.length();
			num += NUMBER_CHARS.indexOf(ncs[i]);
		}

		return num;
	}
	/**
	 * 𐔕ɕϊD
	 * @param num 
	 * @return 
	 */
	protected String toNumberString(int num) {
		return toNumberString(num, 0);
	}
	/**
	 * 𐔕ɕϊ.
	 * @param num 
	 * @param clmns 
	 * @return 
	 */
	protected String toNumberString(int num, int clmns) {
		Stack ncs = new Stack();
		
		do {
			int n = num % NUMBER_CHARS.length();
			String c = "" + NUMBER_CHARS.charAt(n);
			ncs.push(c);
			
			num /= NUMBER_CHARS.length();
		} while(num > 0);

		// 𑵂
		for(int i = ncs.size(); i < clmns; i++) {
			ncs.push("0");
		}
		
		StringBuffer sb = new StringBuffer();
		while(ncs.isEmpty() == false) {
			sb.append(ncs.pop().toString());
		}

		return sb.toString();
	}
	/**
	 * t@CN[YCxg.
	 * @param filename t@C
	 * @param data f[^
	 */
	public void onClose(String filename, byte[] data) {
		FileEntry fe = new FileEntry(filename.trim().toUpperCase(), new String(data));
		fileEntry.put(filename, fe);

		// cookieXV
		updateCookie();
	}
	/**
	 * COOKIEXV.
	 */
	protected void updateCookie() {
		String cookie = getCookie();

		JSObject doc = (JSObject)this.jso.getMember("document");
		doc.setMember("cookie", cookie);
	}
	/**
	 * COOKIEۑ\Ȍ`ɃGXP[v.
	 * <ol>
	 *  <li>Xy[X  %s</li>
	 *  <li>s  %n</li>
	 *  <li>%  %%</li>
	 *  <li>;  %S</li>
	 *  <li>:  %C</li>
	 * </ol>
	 * @param cookie NbL[
	 * @return GXP[vꂽ
	 */
	protected String escapeCookie(String cookie) {
		cookie = cookie.replaceAll("%", "%%");
		cookie = cookie.replaceAll("\n", "%n");
		cookie = cookie.replaceAll("\r", "%r");
		cookie = cookie.replaceAll("\t", "%t");
		cookie = cookie.replaceAll(" ", "%s");
		cookie = cookie.replaceAll(";", "%S");
		cookie = cookie.replaceAll(":", "%C");
		
		return cookie;
	}
	/**
	 * GXP[vꂽ񂩂COOKIE𕜌.
	 * <ol>
	 *  <li>%s  Xy[X</li>
	 *  <li>%n  s</li>
	 *  <li>%%  %</li>
	 *  <li>%S  ;</li>
	 *  <li>%C  :</li>
	 * </ol>
	 * @param cookie GXP[vꂽ
	 * @return COOKIE
	 */
	protected String unescapeCookie(String cookie) {
		char[] cc = cookie.toCharArray();
		StringBuffer sb = new StringBuffer();
		boolean escape = false;

		for(int i = 0; i < cc.length; i++) {
			char c = cc[i];
			if(escape) {
				escape = false;
				switch(c) {
					case 's': c = ' '; break;
					case 'r': c = '\r'; break;
					case 'n': c = '\n'; break;
					case 't': c = '\t'; break;
					case '%': c = '%'; break;
					case 'S': c = ';'; break;
					case 'C': c = ':'; break;
					default: continue;
				}
			} else if(c == '%') {
				escape = true;
				continue;
			}
			sb.append(c);
		}
		
		return sb.toString();
	}
	/**
	 * COOKIE OutputStream.
	 * Cookieɑ΂ăf[^o͂D
	 * @author satoshi akabane@logical-paradox.org
	 * @version $revision$
	 */
	class CookieOutputStream extends OutputStream {
		/** obt@ */
		private final ExpandableBuffer exb = new ExpandableBuffer();
		/** t@CN[YCxgXi[ */
		private FileCloseEventListener closeEventListener;
		/** t@C */
		private String filename;

		/**
		 * RXgN^.
		 * @param filename t@C
		 */
		public CookieOutputStream(String filename) {
			this.filename = filename;
		}
		/**
		 * t@CN[YCxgXi[ݒ肷.
		 * @param lsnr t@CN[YCxgXi[
		 */
		public void setFileCloseEventListener(FileCloseEventListener lsnr) {
			closeEventListener = lsnr;
		}
		/**
		 * 1oCg̃f[^o͂.
		 * @param b oCgf[^
		 * @throws IOException I/OG[
		 */
		public void write(int b) throws IOException {
			exb.write(b);
		}
		/**
		 * o̓Xg[N[Y.
		 * @throws IOException f[^o͂Ɏs
		 */
		public void close() throws IOException {
			if(closeEventListener != null) {
				closeEventListener.onClose(filename, exb.byteStream());
			}
		}
	}
}
