/*
 * $Id: MusicDriver.java,v 1.1 2008/03/16 15:11:04 akabane Exp $
 */
package org.logical_paradox.petitbasic.gui.bios.music;

import org.logical_paradox.petitbasic.gui.hardware.Sound;

/**
 * ~[WbNhCoB
 * ^C}[荞݃[`̈ꕔƂĎB<br>
 * IɋNB
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class MusicDriver extends Thread {
	/** zTEhfoCX */
	private final Sound sound;
	/** f[^ */
	private ControlCode[][] data;
	/** t[TCY(P:msec) */
	private long frameSize;
	/** 荞݃[`ANeBuǂ */
	private boolean active = false;
	/** tǂ */
	private boolean[] running;
	/** ~JE^ */
	private long[] remain;
	/** ݂̉tʒu */
	private int[] framePosition;

	/**
	 * RXgN^B
	 * @param snd zTEhfoCX
	 * @param frs t[TCY(Pmsec)
	 */
	public MusicDriver(Sound snd, long frs) {
		sound = snd;
		frameSize = frs;

		int channels = sound.device.getChannels();
		remain = new long[channels];
		framePosition = new int[channels];
		data = new ControlCode[channels][];
		running = new boolean[channels];

		setDaemon(true);
	}
	/**
	 * w肳ꂽMMLRpCCtJnB
	 * zTEhfoCXŃT|[gĂ`lȏMML͖B
	 * @param mml MML
	 */
	public void play(String[] mml) throws CompilerException {
		synchronized(data) {
			MMLCompiler compiler = new MMLCompiler(frameSize);
			for(int i = 0; i < mml.length && i < data.length; i++) {
				if(mml[i] != null) {
					data[i] = compiler.compile(mml[i]);
				}
			}
			begin();
		}
	}
	/**
	 * Rg[R[hݒ肷B
	 * @param channel `l(0`)
	 * @param cc Rg[R[h
	 */
	public void setControlCode(int channel, ControlCode cc) {
		synchronized(data) {
			data[channel] = new ControlCode[] {cc};
			begin();
		}
	}
	/**
	 * Rg[R[hݒ肷B
	 * @param channel `l(0`)
	 * @param cc Rg[R[h̔z
	 */
	public void setControlCode(int channel, ControlCode[] cc) {
		synchronized(data) {
			data[channel] = cc;
			begin();
		}
	}
	/**
	 * hCotǂԂB
	 * @return true:t / false:tҋ@
	 */
	public boolean isActive() {
		return active;
	}
	/**
	 * tJnB
	 */
	private void begin() {
		// tł΁C~܂őҋ@
		end();
		
		// zTEhfoCXJn
		sound.enable();

		for(int i = 0; i < data.length; i++) {
			if(data[i] != null) {
				running[i] = true;
			}
			remain[i] = 0;
			framePosition[i] = 0;
		}
		active = true;
		sound.enable();
	}
	/**
	 * t𒆎~B
	 */
	private void end() {
		for(int i = 0; i < running.length; i++) {
			running[i] = false;
		}
		
		// zTEhfoCXI
		sound.disable();
	}
	/**
	 * ^C}[荞݃[`B
	 */
	public void run() {
		synchronized(data) {
			loop();
		}
	}
	/**
	 * t[vB
	 * ݂̃f[^SđM܂Ń[v
	 */
	protected void loop() {
		int activeCount = 0;
		for(int i = 0; i < data.length; i++) {
			if(data[i] == null) {
				continue;
			}
			if(remain[i] > 0) {
				// Õt[pĂȂ΁C̃t[ł͉Ȃ
				activeCount++;
				remain[i]--;
			} else {
				boolean breakFlg = false;
				while(!breakFlg && running[i] && framePosition[i] < data[i].length) {
					// t~ɂȂ邩C邢͑SẴf[^𑗐M܂Ń[v
					activeCount++;
					ControlCode cc = data[i][framePosition[i]++];
					switch(cc.controlCode) {
						// ʐݒ
						case ControlCode.VOLUME:
							sound.setPort(Sound.VOL_REG_1 + i, (int)cc.value);
							break;
						// g`ݒ
						case ControlCode.WAVE:
							sound.setPort(Sound.WAVE_REG_1 + i, (int)cc.value);
							break;
						// m[g̔
						case ControlCode.NOTE:
							sound.setPort(Sound.TONE_REG_1 + i, (int)cc.value);
							remain[i] = cc.length;
							breakFlg = true;
							break;
						// x̏
						case ControlCode.REST:
							sound.setPort(Sound.OUT_CTL_REG_1 + i, 0);
							remain[i] = cc.length;
							breakFlg = true;
							break;
						// T|[gÕR[h͖
						default:
							break;
					}
				}
				// t~Ԃɐݒ肷
				if(framePosition[i] >= data[i].length) {
					running[i] = false;
				}
			}
		}
		
		active = activeCount > 0;
		
		if(active == false) {
			sound.disable();
			for(int i = 0; i < sound.getChannels(); i++) {
				sound.setPort(Sound.OUT_CTL_REG_1 + i, 0);		// mute
				data[i] = new ControlCode[0];
			}
		}
	}
	/**
	 * BEEP𔭐D
	 */
	public void beep() {
		setControlCode(0, new ControlCode[] {
				new ControlCode(ControlCode.VOLUME, 13),
				new ControlCode(ControlCode.NOTE, 85, 4)
			}
		);
	}
}
