/*
 * $Id: Auto.java,v 1.3 2006/10/21 08:55:57 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.gui.ext;

import org.logical_paradox.petitbasic.builtin.BuiltinCommand;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnv;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnvHolder;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.runtime.exception.NoopException;

/**
 * AUTO߁D
 * <br><pre>
 * @\Fsԍ𔭔ԂD
 * ʁFR}h<br>
 * FAUTO [sԍ][,<>]
 * ᕶFAUTO 100,5
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class Auto implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		ctx.config.log.println("AUTOߎsJn");

		Token token = null;
		Token first = null;
		Token step = null;
		int state = 0;
		final int FINITE = 3;
		Expression expression = new Expression(env, ctx, line);

		// (q0, digit) = q1
		// (q0, ',') = q2
		// (q0, e) = f
		// (q1, ',') = q2
		// (q1, e) = f
		// (q2, digit) = f
		while(state < FINITE) {
			switch(state) {
				case -1:
					throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1);
				// q0
				case 0:
					token = line.getNextValidToken();
					if(token == null) {
						state = FINITE;
					} else if(",".equals(token.toString())) {
						state = 2;
					} else {
						line.rewind();
						first = expression.eval();
						state = 1;
					}
					break;
				// q1
				case 1:
					token = line.getNextValidToken();
					if(token == null || ",".equals(token.toString()) == false) {
						state = FINITE;
					} else {
						state = 2;
					}
					break;
				// q2
				case 2:
					token = line.getNextValidToken();
					if(token != null && token.getType() != Token.TYPE_DELIMITER) {
						line.rewind();
						step = expression.eval();
					}
					state = FINITE;
					break;
				default:
					ctx.config.log.println("AUTO߂\ȂԂ֑Jڂ܂");
					throw new BasicLanguageException(ErrorCodeConstant.INTERNAL_ERROR, -1);
			}
		}

		int beginLineNum = 10;
		int lineNumStep = 10;
		PetitBasicGuiRuntimeEnv genv = PetitBasicGuiRuntimeEnvHolder.getEnvironment();

		// Jnsԍ
		if(first != null) {
			beginLineNum = OperationUtils.intValue(first, ctx);
		}
		// 
		if(step != null) {
			lineNumStep = OperationUtils.intValue(step, ctx);
		}

		// sԍԊJn
		genv.autoLineNumber = true;
		// Jnsԍ
		env.setLastEntryLine(beginLineNum - lineNumStep);
		// 
		genv.autoLineNumberStep = lineNumStep;

		ctx.config.log.println("AUTOߎsI");

		// vO̎sI
		throw new NoopException(-1);
	}

}
