/*
 * $Id: Circle.java,v 1.9 2008/05/05 02:26:38 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.gui.ext;

import java.util.ArrayList;
import java.util.List;

import org.logical_paradox.petitbasic.builtin.BuiltinCommand;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnv;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnvHolder;
import org.logical_paradox.petitbasic.gui.hardware.VDP;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * CIRCLED
 * <br><pre>
 * @\FOtBbNʂɑ΂āC~`悷D
 * ʁFXe[gg<br>
 * FCIRCLE(<XW>,<YW>),<a>[,<F>][,<G>]
 * ᕶFCIRCLE(256,128),50,15
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.9 $
 */
public class Circle implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		ctx.config.log.println("CIRCLEsJn");

		Expression expr = new Expression(env, ctx, line, true);
		List tokens = new ArrayList();
		while(expr.hasNextToken()) {
			tokens.add(expr.eval());
		}

		if(tokens.size() < 2) {
			// ̐sȂ̂ŁCSyntaxError
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1);
		}
		Token radiusToken = null;
		Token colorToken = null;
		Token ellipToken = null;

		if(
			",".equals("" + line.getNextValidToken()) == false ||
			(radiusToken = expr.eval()) == null ||
			expr.isTerminated() == true ||
			(colorToken = expr.eval()) == null
		) {
			// ,<radius>,<color-code>̏łȂꍇ̓G[Ƃ
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1);
		}
		tokens.add(radiusToken);
		tokens.add(colorToken);

		if(expr.isTerminated() == false && (ellipToken = expr.eval()) != null) {
			// Gw肳ꂽꍇ
			ellipToken = OperationUtils.castValueType(ellipToken, Token.VTYPE_DBL, ctx);
			tokens.add(ellipToken);
		} else {
			// GȗꂽꍇC1.0̉~`
			ellipToken = new Token(Token.TYPE_LITERAL);
			ellipToken.setValueType(Token.VTYPE_DBL);
			ellipToken.setRealValue(ctx.config.mathpack.doubleValue(1.0d));
		}

		int[] values = new int[4];
		for(int i = 0; i < values.length; i++) {
			Token token = (Token)tokens.get(i);
			if(
				token.getType() != Token.TYPE_LITERAL ||
				token.getValueType() == Token.VTYPE_STR ||
				(token.getValueType() == Token.VTYPE_DEF && ctx.getDefaultVarType() == Token.VTYPE_STR)
			) {
				throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1);
			} else {
				int valueType = token.getValueType();
				if(valueType == Token.VTYPE_DEF) {
					valueType = ctx.getDefaultVarType();
				}
				switch(valueType) {
					// Px^E{x^
					case Token.VTYPE_DBL:
					case Token.VTYPE_SGL:
						values[i] = ctx.config.mathpack.fp_INT(token.getRealValue()).intValue();
						break;
					// ^
					case Token.VTYPE_INT:
						values[i] = (int)token.getIntValue();
						break;
					default:
						// vOs
						throw new BasicLanguageException(ErrorCodeConstant.INTERNAL_ERROR, -1);
				}
			}
		}

		PetitBasicGuiRuntimeEnv genv = PetitBasicGuiRuntimeEnvHolder.getEnvironment();
		VDP vdp = genv.vdp;
		int x = values[0];
		int y = values[1];
		int r = values[2];
		int c = genv.config.getWindowForecolorCode();
		if(values.length > 3) {
			// J[R[h
			c = values[3];
		}
		double ellipcity = Double.parseDouble(ellipToken.getRealValue().toString(false));
		vdp.ellipse(x, y, r, ellipcity, c, VDP.LOPR_NOP);

		// zʂĕ`悷(ōĕ`悵ȂƁCvOs܂ōĕ`悳Ȃ)
		genv.display.repaint(genv.config);

		ctx.config.log.println("CIRCLEsI");

		return null;
	}

}
