/*
 * $Id: Key.java,v 1.7 2008/08/31 09:03:58 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.gui.ext;

import java.io.PrintWriter;

import org.logical_paradox.petitbasic.builtin.BuiltinCommand;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiConfig;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnv;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnvHolder;
import org.logical_paradox.petitbasic.gui.bios.ASCIICode;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * KEY߁D
 * <br><pre>
 * @\Ft@NVL[ɑ΂ݒsȂD
 * ʁFR}h<br>
 * FKEY LIST@@@@@@@@@t@NVL[̓e\D
 * @@@KEY <L[ԍ>,<>@ t@NVL[Ē`D
 * @@@KEY {ON|OFF}@@@@@@@t@NVL[̓eʉiɕ\邩ǂw肷D
 * ᕶFKEY LIST
 *@@@ KEY 1, "run" + CHR$(13)
 * @@@KEY ON
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.7 $
 */
public class Key implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		ctx.config.log.println("KEYߎsJn");

		line.skipWhiteSpace();
		if(line.hasMoreTokens() == false) {
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1);
		}
		// 1擾
		Expression expr = new Expression(env, ctx, line);
		Token firstArgumentToken = line.peekNextValidToken();

		if("LIST".equals(firstArgumentToken.toString().toUpperCase()) == true) {
			line.getNextValidToken();		// ǂݎ̂
			// KEY LIST
			procKeyList(env, ctx);
		} else if(
			"ON".equals(firstArgumentToken.toString().toUpperCase()) ||
			"OFF".equals(firstArgumentToken.toString().toUpperCase())
		) {
			// KEY {ON|OFF}
			line.getNextValidToken();		// ǂݎ̂
			procKeyOnOff(firstArgumentToken, env, ctx);
		} else {
			firstArgumentToken = expr.eval();
			if(
				firstArgumentToken.getType() == Token.TYPE_LITERAL &&
				(firstArgumentToken.getValueType() != Token.VTYPE_STR ||
				(firstArgumentToken.getValueType() == Token.VTYPE_DEF && !(ctx.getDefaultVarType() == Token.VTYPE_STR)))
			) {
				// KEY <n>,<string>
				procKeySet(firstArgumentToken, env, ctx, expr);
			} else {
				// ȊO͍\G[
				throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1);
			}
		}
		ctx.config.log.println("KEYߎsI");

		return null;
	}
	/**
	 * KEY LIST߂D
	 * @param env ^C
	 * @param ctx ^CReLXg
	 */
	protected void procKeyList(BasicRuntimeEnvironment env, BasicRuntimeContext ctx) {
		ctx.config.log.println("KEY LIST̏o͊Jn");

		PetitBasicGuiRuntimeEnv genv = PetitBasicGuiRuntimeEnvHolder.getEnvironment();
		String[] keylist = genv.config.functionKeyStrings;
		PrintWriter pw = new PrintWriter(ctx.getOutputStream());
		
		// L[Xg̏o
		for(int i = 0; i < keylist.length; i++) {
			pw.print(keylist[i].trim());
			pw.print(ASCIICode.CR);
			pw.print(ASCIICode.LF);
			pw.flush();
		}
	}
	/**
	 * KEY ON/OFF߂D
	 * @param firstArgumentToken 1
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @throws BasicLanguageException \G[
	 */
	protected void procKeyOnOff(Token firstArgumentToken, BasicRuntimeEnvironment env, BasicRuntimeContext ctx) throws BasicLanguageException {
		PetitBasicGuiRuntimeEnv genv = PetitBasicGuiRuntimeEnvHolder.getEnvironment();
		String opt = firstArgumentToken.toString().toUpperCase();
		boolean state = false;

		if("ON".equals(opt) == true) {
			state = true;
		} else if("OFF".equals(opt)) {
			state = false;
		} else {
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1);
		}
		
		// eLXgʂ̍ŉiNA
		int[] data = new int[genv.config.getCharsHorizonMax()];
		genv.stdout.tvram.vpoke(0, genv.config.getCharsVerticalMaxActual()-1, data);

		// t@NVL[̐ݒύX
		genv.config.functionKeyDisplay = state;

		// eLXgʂ̍ĕ`
		genv.stdout.flush();
		genv.screenEditor.displayFunctionKey();
	}
	/**
	 * KEY <n>, <string>߂D
	 * @param firstArgumentToken 1
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param expr vZbT
	 * @throws BasicLanguageException BASICŃG[
	 */
	protected void procKeySet(Token firstArgumentToken, BasicRuntimeEnvironment env, BasicRuntimeContext ctx, Expression expr) throws BasicLanguageException {
		ctx.config.log.println("t@NVL[̐ݒJn");

		// J}
		Token comma = expr.getBasicCommandLine().getNextValidToken();
		if(comma == null || ",".equals(comma.toString()) == false) {
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1);
		}

		// 
		PetitBasicGuiRuntimeEnv genv = PetitBasicGuiRuntimeEnvHolder.getEnvironment();
		Token token = expr.eval();

		if(
			token.getType() != Token.TYPE_LITERAL ||
			OperationUtils.isStringValueType(token.getValueType(), ctx.getDefaultVarType()) == false
		) {
			throw new BasicLanguageException(ErrorCodeConstant.TYPE_MISMATCH, -1);
		}
		
		int keyNum = OperationUtils.intValue(firstArgumentToken, ctx);
		if(keyNum < 1 || keyNum > PetitBasicGuiConfig.MAX_FUNCTION_KEY_SETS) {
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1);
		}
		genv.config.functionKeyStrings[keyNum-1] = token.getStrValue();
	}
}
