/*
 * $Id: Keysns.java,v 1.1 2008/10/19 16:48:45 akabane Exp $
 */
package org.logical_paradox.petitbasic.gui.ext;

import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnvHolder;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.sysvar.SystemVariable;
import org.logical_paradox.petitbasic.sysvar.SystemVariableContext;

/**
 * KEYSNSD
 * <br><pre>
 * @\FL[{[h̏ԂԂD
 * ʁFVXeϐ<br>
 * FKEYSNS(<sԍ>)
 * ᕶFA=KEYSNS(1)
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class Keysns implements SystemVariable {
	/**
	 * VXeϐɑ΂ĒlD
	 * ̃\bh́CVXeϐɑ΂ɌĂяoD
	 * @param svc VXeϐReLXg
	 * @throws BasicLanguageException BASICsG[
	 */
	public void assign(SystemVariableContext svc) throws BasicLanguageException {
		// ̃VXeϐւ̒l͕̑s
		throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1);
	}
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		Token token = line.peekNextValidToken();
		if(token == null || token.getType() != Token.TYPE_BRACKET) {
			// JbRłȂꍇ͍\G[
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
		}
		
		// ̎擾
		Expression expr = new Expression(env, ctx, line, true);
		token = expr.eval();
		if(!expr.isTerminated() || token == null || token.getType() != Token.TYPE_LITERAL) {
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
		}

		// L[{[h̉Ԃ擾
		int keyStateLineNo = (int)OperationUtils.castValueType(token, Token.VTYPE_INT, ctx).getIntValue();
		long bit = PetitBasicGuiRuntimeEnvHolder.getEnvironment().keyInputDevice.getKeyState(keyStateLineNo);

		// ߂l̍쐬
		token = new Token(Token.TYPE_LITERAL);
		token.setValueType(Token.VTYPE_INT);
		token.setDecimalFormat(Token.DF_INT);
		token.setIntValue(bit);
		
		return token;
	}

}
