/*
 * $Id: Locate.java,v 1.1 2008/09/13 14:22:58 akabane Exp $
 */
package org.logical_paradox.petitbasic.gui.ext;

import java.util.ArrayList;
import java.util.List;

import org.logical_paradox.petitbasic.builtin.BuiltinCommand;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnv;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnvHolder;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * LOCATED
 * <br><pre>
 * @\FJ[\Cӂ̈ʒuֈړD
 * ʁFXe[gg<br>
 * FLOCATE <XW>,<YW>
 * ᕶFLOCATE 0,15
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class Locate implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		List tokens = new ArrayList();
		Token comma = null;
		Expression expr = new Expression(env, ctx, line, false);
		
		while(expr.hasNextToken()) {
			tokens.add(expr.eval());
			comma = line.peekNextValidToken();
			if(comma == null || !",".equals(comma.toString())) {
				break;
			}
			line.getNextValidToken();		// J}XLbv
		}

		if(tokens.size() != 2) {
			// ̐s
			throw new BasicLanguageException(ErrorCodeConstant.MISSING_OPERAND, line.getLineno());
		}

		Token p1 = (Token)tokens.get(0);
		Token p2 = (Token)tokens.get(1);
		int x = (int)OperationUtils.castValueType(p1, Token.VTYPE_INT, ctx).getIntValue();
		int y = (int)OperationUtils.castValueType(p2, Token.VTYPE_INT, ctx).getIntValue();

		PetitBasicGuiRuntimeEnv genv = PetitBasicGuiRuntimeEnvHolder.getEnvironment();
		if(
			x < 0 || x >= genv.config.getCharsHorizonMax() ||
			y < 0 || y >= genv.config.getCharsVerticalMax()
		) {
			// J[\Wړ\ʒu͈̔͂𒴂Ăꍇ͔͈̓G[
			throw new BasicLanguageException(ErrorCodeConstant.ARGUMENT_OUT_OF_RANGE, line.getLineno());
		}
		genv.cursorXpos = x;
		genv.cursorYpos = y;

		return null;
	}

}
