/*
 * $Id: Mouse.java,v 1.2 2007/02/25 15:09:47 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.gui.ext;

import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnvHolder;
import org.logical_paradox.petitbasic.gui.hardware.MouseDevice;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.sysvar.SystemVariable;
import org.logical_paradox.petitbasic.sysvar.SystemVariableContext;

/**
 * MOUSED
 * <br><pre>
 * @\F}EXfoCX̏ԂԂD
 * ʁFVXeϐ
 * FMOUSE(<>)
 * @@@@@0: }EXXW
 * @@@@@1: }EXYW
 * @@@@@2: }EXXW
 * @@@@@3: }EXYW
 * ᕶFX=X+MOUSE(2)
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class Mouse implements SystemVariable {
	/**
	 * VXeϐɑ΂ĒlD
	 * ̃\bh́CVXeϐɑ΂ɌĂяoD
	 * @param svc VXeϐReLXg
	 * @throws BasicLanguageException BASICsG[
	 */
	public void assign(SystemVariableContext svc) throws BasicLanguageException {
		throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1);
	}
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		Expression expr = new Expression(env, ctx, line, true);
		Token token = expr.eval();

		if(
			expr.hasNextToken() ||
			token.getType() != Token.TYPE_LITERAL
		) {
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
		}

		int param = OperationUtils.intValue(token, ctx);
		MouseDevice mouse = PetitBasicGuiRuntimeEnvHolder.getEnvironment().mouseDevice;
		int value = 0;
		switch(param) {
			case 0:				// XW
				value = mouse.getX();
				break;
			case 1:				// YW
				value = mouse.getY();
				break;
			case 2:				// XW
				value = mouse.getXX();
				break;
			case 3:				// YW
				value = mouse.getYY();
				break;
			default:
				// ͈̔͂
				throw new BasicLanguageException(ErrorCodeConstant.MISSING_OPERAND, line.getLineno());
		}
		
		Token result = new Token(Token.TYPE_LITERAL);
		result.setIntValue(value);
		result.setValueType(Token.VTYPE_INT);
		result.setDecimalFormat(Token.DF_INT);

		return result;
	}

}
