/*
 * $Id: On.java,v 1.1 2008/08/31 17:12:56 akabane Exp $
 */
package org.logical_paradox.petitbasic.gui.ext;

import org.logical_paradox.petitbasic.builtin.BuiltinCommand;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * OND
 * <br><pre>
 * @\FON SPRITE GOSUB̑̏sD
 * ʁFXe[gg
 * FON SPRITE GOSUB <sԍ>
 * ᕶFON SPRITE GOSUB 1000
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class On implements BuiltinCommand {
	/** GOSUBRR[h - XvCg荞 */
	public static final int REASON_SPRITE_INTERRUPT = 100;

	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		Token target = line.getNextValidToken();
		if(
			!"SPRITE".equals(target.toString()) ||
			(!"GOSUB".equals(line.getNextValidToken()))
		) {
			// ON SPRITE GOSUB
			Expression expr = new Expression(env, ctx, line);
			Token v = expr.eval();
			if(v == null) {
				// sԍw肳ĂȂ
				throw new BasicLanguageException(ErrorCodeConstant.MISSING_OPERAND, line.getLineno());
			}
			int lineno = (int)OperationUtils.castValueType(v, Token.VTYPE_INT, ctx).getIntValue();
			
			// XvCgՓ˃Cxg̃nhݒ肷
			Sprite.lineno = lineno;

		} else {
			// ȊO͊NXɏϏ
			line.rewind();
		}
		return null;
	}

}
