/*
 * $Id: Play.java,v 1.4 2008/06/04 17:31:30 akabane Exp $
 */
package org.logical_paradox.petitbasic.gui.ext;

import org.logical_paradox.petitbasic.builtin.BuiltinCommand;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnv;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnvHolder;
import org.logical_paradox.petitbasic.gui.bios.music.CompilerException;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * PLAYD
 * <br><pre>
 * @\FMMLŋLqꂽytD
 * ʁFXe[gg
 * FPLAY [MML][,MML][,MML]
 * ᕶFPLAY "T120O4L4V3CDEFGABO5C"
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.4 $
 */
public class Play implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		PetitBasicGuiRuntimeEnv genv = PetitBasicGuiRuntimeEnvHolder.getEnvironment();
		Expression expr = new Expression(env, ctx, line);
		String[] mml = new String[genv.psg.getChannels()];
		for(int i = 0; i < mml.length; i++) {
			mml[i] = "";
		}
		int ch = 0;
		boolean check = true;
		Token token = null;

		while(
			ch < mml.length &&
			line.hasMoreTokens()
		) {
			token = line.peekNextValidToken();
			if(",".equals(token.toString())) {
				line.getNextValidToken();		// J}̂Ă
				ch++;
				check = true;
			} else if(
				(token = expr.eval()) != null &&
				token.getType() == Token.TYPE_LITERAL && token.getValueType() == Token.VTYPE_STR && check) {
				mml[ch] = token.toString();
				check = false;
			} else {
				// \G[
				throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
			}
		}

		// tJn
		try {
			genv.md.play(mml);
		} catch(CompilerException e) {
			// MML̍\G[
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
		}
		return null;
	}

}
