/*
 * $Id: Pos.java,v 1.2 2007/02/25 15:09:47 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.gui.ext;

import java.util.ArrayList;
import java.util.List;

import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnv;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnvHolder;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.sysvar.SystemVariable;
import org.logical_paradox.petitbasic.sysvar.SystemVariableContext;

/**
 * POSD
 * <br><pre>
 * @\F݂̃J[\XWԂDW̓eLXgWnŕ\D
 * ʁFVXeϐ<br>
 * FPOS(<>) *ɈӖ͂Ȃ
 * ᕶFX=POS(0)
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class Pos implements SystemVariable {
	/**
	 * VXeϐɑ΂ĒlD
	 * ̃\bh́CVXeϐɑ΂ɌĂяoD
	 * @param svc VXeϐReLXg
	 * @throws BasicLanguageException BASICsG[
	 */
	public void assign(SystemVariableContext svc) throws BasicLanguageException {
		// ̃VXeϐɑ邱Ƃ͂łȂ
		throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1);
	}
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		// D̓eɈӖ͂Ȃ
		Expression expr = new Expression(env, ctx, line, true);
		List tokens = new ArrayList();
		while(expr.hasNextToken()) {
			tokens.add(expr.eval());
		}

		// ̉
		if(tokens.size() != 1) {
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
		}
		OperationUtils.intValue((Token)tokens.get(0), ctx);

		PetitBasicGuiRuntimeEnv genv = PetitBasicGuiRuntimeEnvHolder.getEnvironment();

		Token token = new Token(Token.TYPE_LITERAL);
		token.setValueType(Token.VTYPE_INT);
		token.setDecimalFormat(Token.DF_INT);
		token.setIntValue(genv.cursorXpos);

		return token;
	}

}
