/*
 * $Id: Pset.java,v 1.1 2008/10/26 15:20:33 akabane Exp $
 */
package org.logical_paradox.petitbasic.gui.ext;

import java.util.ArrayList;
import java.util.List;

import org.logical_paradox.petitbasic.builtin.BuiltinCommand;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnv;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnvHolder;
import org.logical_paradox.petitbasic.gui.hardware.VDP;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * PSETD
 * <br><pre>
 * @\Fw肳ꂽFŃhbgzuD
 * ʁFXe[gg<br>
 * FPSET(<XW>,<YW>),<F>
 * ᕶFPSET(256,128),15
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class Pset implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		ctx.config.log.println("PSETsJn");

		Expression expr = new Expression(env, ctx, line, true);
		List tokens = new ArrayList();
		while(expr.hasNextToken()) {
			tokens.add(expr.eval());
		}

		if(tokens.size() < 2) {
			// ̐sȂ̂ŁCSyntaxError
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1);
		}
		Token colorToken = null;

		if(
			",".equals("" + line.getNextValidToken()) == false ||
			(colorToken = expr.eval()) == null
		) {
			// ,<color-code>̏łȂꍇ̓G[Ƃ
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1);
		}
		tokens.add(colorToken);

		int[] values = new int[3];
		for(int i = 0; i < values.length; i++) {
			Token token = (Token)tokens.get(i);
			if(
				token.getType() != Token.TYPE_LITERAL ||
				token.getValueType() == Token.VTYPE_STR ||
				(token.getValueType() == Token.VTYPE_DEF && ctx.getDefaultVarType() == Token.VTYPE_STR)
			) {
				throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1);
			} else {
				int valueType = token.getValueType();
				if(valueType == Token.VTYPE_DEF) {
					valueType = ctx.getDefaultVarType();
				}
				switch(valueType) {
					// Px^E{x^
					case Token.VTYPE_DBL:
					case Token.VTYPE_SGL:
						values[i] = ctx.config.mathpack.fp_INT(token.getRealValue()).intValue();
						break;
					// ^
					case Token.VTYPE_INT:
						values[i] = (int)token.getIntValue();
						break;
					default:
						// vOs
						throw new BasicLanguageException(ErrorCodeConstant.INTERNAL_ERROR, -1);
				}
			}
		}

		PetitBasicGuiRuntimeEnv genv = PetitBasicGuiRuntimeEnvHolder.getEnvironment();
		VDP vdp = genv.vdp;
		int x = values[0];
		int y = values[1];
		int c = values[2];

		// PSET
		vdp.pset(x, y, c, VDP.LOPR_NOP);

		// zʂĕ`悷(ōĕ`悵ȂƁCvOs܂ōĕ`悳Ȃ)
		genv.display.repaint(genv.config);

		ctx.config.log.println("PSETsI");

		return null;
	}
}
