/*
 * $Id: Return.java,v 1.1 2008/08/31 17:12:56 akabane Exp $
 */
package org.logical_paradox.petitbasic.gui.ext;

import java.util.Stack;

import org.logical_paradox.petitbasic.builtin.syntax.Gosub;
import org.logical_paradox.petitbasic.builtin.syntax.GosubReturnContext;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * RETURND
 * <br><pre>
 * @\FTu[`畜A܂D
 * ʁFXe[gg<br>
 * FRETURN [sԍ]
 * ᕶFRETURN 1200
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class Return extends org.logical_paradox.petitbasic.builtin.syntax.Return {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		// Tu[`N̗RXvCgՓ˂̏ꍇCSPRITE ONs
		Stack calling = ctx.getCallingStructureContext(Gosub.CTXKEY_GOSUB_STACK);
		if(calling.size() > 0) {
			GosubReturnContext gosubContext = (GosubReturnContext)calling.peek();
			if(gosubContext.reason == On.REASON_SPRITE_INTERRUPT) {
				// 荞ݍĊJ
				Sprite.interrupt = Sprite.INT_ON;
			}
		}

		// X[p[NX({RETURN)ɏڂ
		return super.execute(env, ctx, line);
	}
}
