/*
 * $Id: Screen.java,v 1.1 2008/08/31 09:03:58 akabane Exp $
 */
package org.logical_paradox.petitbasic.gui.ext;

import org.logical_paradox.petitbasic.builtin.BuiltinCommand;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnvHolder;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * SCREEND
 * <br><pre>
 * @\Fʂ̕\[hύXD
 * ʁFXe[gg
 * FSCREEN <[h>
 *      0: EBhE\
 *      1: tXN[\
 * ᕶFSCREEN 1
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class Screen implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		Expression expr = new Expression(env, ctx, line, false);
		Token modeToken = expr.eval();
		
		if(modeToken == null) {
			// p[^sĂ
			throw new BasicLanguageException(ErrorCodeConstant.MISSING_OPERAND, line.getLineno());
		}
		int mode = (int)OperationUtils.castValueType(modeToken, Token.VTYPE_INT, ctx).getIntValue();
		boolean fullScreen = false;
		switch(mode) {
			case 0:		fullScreen = false;break;
			case 1:		fullScreen = true;break;
			default:
				throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
		}
		
		PetitBasicGuiRuntimeEnvHolder.getEnvironment().display.setFullScreen(fullScreen);

		return null;
	}

}
