/*
 * $Id: SpriteDL.java,v 1.4 2008/06/04 17:31:30 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.gui.ext;

import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnv;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnvHolder;
import org.logical_paradox.petitbasic.gui.hardware.SpriteEngine;
import org.logical_paradox.petitbasic.gui.hardware.SpritePattern;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.sysvar.SystemVariable;
import org.logical_paradox.petitbasic.sysvar.SystemVariableContext;

/**
 * SPRITE$D
 * <br><pre>
 * @\FXvCg`D
 * ʁFVXeϐ<br>
 * FSPRITE$(<XvCgԍ>)=<`>
 * ᕶFSPRITE$(0)="00001111FFFFDDDDCCCCAAA"
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.4 $
 */
public class SpriteDL implements SystemVariable {
	/**
	 * VXeϐɑ΂ĒlD
	 * ̃\bh́CVXeϐɑ΂ɌĂяoD
	 * @param svc VXeϐReLXg
	 * @throws BasicLanguageException BASICsG[
	 */
	public void assign(SystemVariableContext svc) throws BasicLanguageException {
		int[] params = svc.subscripts;
		if(params == null || params.length != 1) {
			// ̐
			throw new BasicLanguageException(ErrorCodeConstant.MISSING_OPERAND, svc.line.getLineno());
		}
		if(svc.token.getType() != Token.TYPE_LITERAL || svc.token.getValueType() != Token.VTYPE_STR) {
			// l
			throw new BasicLanguageException(ErrorCodeConstant.TYPE_MISMATCH, svc.line.getLineno());
		}

		int ptnno = params[0];

		PetitBasicGuiRuntimeEnv genv = PetitBasicGuiRuntimeEnvHolder.getEnvironment();
		SpriteEngine spvram = genv.vdp.spEngine;
		
		if(ptnno >= spvram.getSpriteMaxDecl() || ptnno < 0) {
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1);
		}

		// XvCgp^[`
		try {
			SpritePattern sprite = new SpritePattern(spvram.spriteSize.width, spvram.spriteSize.height, genv.config);
			sprite.define(svc.token.getStrValue());
			spvram.setSprite(ptnno, sprite);
		} catch(NumberFormatException ne) {
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1, ne);
		}
	}
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		// l̎擾͕s\Ƃ(U)
		throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
	}

}
