/*
 * $Id: Strig.java,v 1.2 2007/02/25 15:09:47 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.gui.ext;

import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnvHolder;
import org.logical_paradox.petitbasic.gui.hardware.MouseDevice;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.sysvar.SystemVariable;
import org.logical_paradox.petitbasic.sysvar.SystemVariableContext;

/**
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class Strig implements SystemVariable {
	/**
	 * VXeϐɑ΂ĒlD
	 * ̃\bh́CVXeϐɑ΂ɌĂяoD
	 * @param svc VXeϐReLXg
	 * @throws BasicLanguageException BASICsG[
	 */
	public void assign(SystemVariableContext svc) throws BasicLanguageException {
		throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1);
	}
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		Expression expr = new Expression(env, ctx, line, true);
		Token token = expr.eval();

		if(
			expr.hasNextToken() ||
			token.getType() != Token.TYPE_LITERAL
		) {
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
		}

		int param = OperationUtils.intValue(token, ctx);
		MouseDevice mouse = PetitBasicGuiRuntimeEnvHolder.getEnvironment().mouseDevice;
		int value = 0;

		switch(param) {
			case 0:				// Xy[XL[
				break;
			case 1:				// }EX{^
				value = mouse.getButtonState(MouseDevice.BUTTON_LEFT) ? -1 : 0;
				break;
			case 2:				// }EXE{^
				value = mouse.getButtonState(MouseDevice.BUTTON_RIGHT) ? -1 : 0;
				break;
			case 3:				// }EX{^
				value = mouse.getButtonState(MouseDevice.BUTTON_MIDDLE) ? -1 : 0;
				break;
			default:
				// ͈̔͂
				throw new BasicLanguageException(ErrorCodeConstant.MISSING_OPERAND, line.getLineno());
		}
		Token result = new Token(Token.TYPE_LITERAL);
		result.setIntValue(value);
		result.setValueType(Token.VTYPE_INT);
		result.setDecimalFormat(Token.DF_INT);

		return result;
	}

}
