/*
 * $Id: InterruptController.java,v 1.1 2008/08/28 18:45:34 akabane Exp $
 */
package org.logical_paradox.petitbasic.gui.hardware;

/**
 * 荞݃Rg[[B
 * @author satoshi akabane@logical-paradox.org
 * @version $revision$
 */
public class InterruptController {
	/** 荞ݗv */
	private IRQ[] irqs;

	/**
	 * RXgN^B
	 * @param channel `l
	 */
	public InterruptController(int channels) {
		irqs = new IRQ[channels];
	}
	/**
	 * 荞݃nho^B
	 * @param ch `lԍ
	 * @param ih 荞݃nh
	 * @param interval 荞݊Ԋu
	 */
	public void register(int ch, InterruptHandler ih, int interval) {
		IRQ irq = irqs[ch];
		if(irq != null) {
			irq.shutdown();
		}
		irq = new IRQ(ih, interval);
		irqs[ch] = irq;
		
		irq.start();
	}
	/**
	 * 荞ݗvB
	 * @author satoshi akabane@logical-paradox.org
	 * @version $revision$
	 */
	class IRQ extends Thread {
		/** 荞݃nh */
		private InterruptHandler ih;
		/** 荞݊Ԋu(msec) */
		private long interval;
		/** I */
		private boolean exitf = false;

		/**
		 * RXgN^B
		 * @param ih 荞݃nh
		 * @param interval 荞݊Ԋu
		 */
		private IRQ(InterruptHandler ih, long interval) {
			setDaemon(true);
			this.ih = ih;
			this.interval = interval;
		}
		/**
		 * XbhCB
		 */
		public void run() {
			while(!exitf) {
				long before = System.currentTimeMillis();
				ih.proc();
				long remain = interval - (System.currentTimeMillis() - before);
				if(remain > 0) {
					try {
						Thread.sleep(remain);
					} catch(InterruptedException e) {
						exitf = true;
					}
				}
			}
		}
		/**
		 * Vbg_EB
		 * ̃\bhĂяoĂɂ̓Xbh~ȂB
		 */
		public void shutdown() {
			exitf = true;
		}
	}
}
