/*
 * $Id: VDP.java,v 1.14 2008/07/26 03:26:26 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.gui.hardware;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.DataBufferInt;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

import org.logical_paradox.common.util.NumberUtils;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiConfig;

/**
 * rfIEfBXvCEvZbT[D
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.14 $
 */
public class VDP {
	/** OtBbNVRAM */
	public final GraphicVRAM gvram;
	/** XvCgGW */
	public final SpriteEngine spEngine;

	/** _Zq L[[h - OR */
	public static final String LOPS_OR = "OR";
	/** _Zq L[[h - AND */
	public static final String LOPS_AND = "AND";
	/** _Zq L[[h - XOR */
	public static final String LOPS_XOR = "XOR";
	/** _Zq L[[h - EQV */
	public static final String LOPS_EQV = "EQV";
	/** _Zq L[[h - IMP */
	public static final String LOPS_IMP = "IMP";
	/** _Zq L[[h - NOT */
	public static final String LOPS_NOT = "NOT";

	/** _Z - OR */
	public static final int LOPR_OR = 1;
	/** _Z - AND */
	public static final int LOPR_AND = 2;
	/** _Z - XOR */
	public static final int LOPR_XOR = 3;
	/** _Z - EQV */
	public static final int LOPR_EQV = 4;
	/** _Z - IMP */
	public static final int LOPR_IMP = 5;
	/** _Z - NOT */
	public static final int LOPR_NOT = 6;
	/** _Z - no operation */
	public static final int LOPR_NOP = 99;

	/** _Z - ߃[h */
	public static final int LOPR_TRANSPARENT = 128;

	private static final Map LOPR_OPS_MAP;
	private final PetitBasicGuiConfig config;
	/*
	 * X^eBbNCjVCU
	 */
	static {
		// _Zq̗\_ZR[hɕϊ}bv쐬
		Map map = new HashMap();
		map.put(LOPS_OR, new Integer(LOPR_OR));
		map.put(LOPS_AND, new Integer(LOPR_AND));
		map.put(LOPS_XOR, new Integer(LOPR_XOR));
		map.put(LOPS_EQV, new Integer(LOPR_EQV));
		map.put(LOPS_IMP, new Integer(LOPR_IMP));
		map.put(LOPS_NOT, new Integer(LOPR_NOT));

		LOPR_OPS_MAP = Collections.unmodifiableMap(map);
	}
	/**
	 * RXgN^D
	 * @param gv OtBbNVRAM
	 * @param spe XvCgGW
	 * @param gc PetitBASIC GUIRtBO[V
	 */
	public VDP(GraphicVRAM gv, SpriteEngine spe, PetitBasicGuiConfig gc) {
		gvram = gv;
		spEngine = spe;
		config = gc;
	}
	/**
	 * yCgD
	 * Jn(x,y)W̐FwiFƂCwiFSĎwFœhԂD<br>
	 * XLCV[htBASYɂ.
	 * wiFȊO͑SċEFƂD
	 * @param x JnXW
	 * @param y JnYW
	 * @param cc J[R[h
	 */
	public void paint(int x, int y, int cc) {
		PaintContext ctx = new PaintContext();
		ctx.bgcolor = gvram.vpeek(x, y);
		ctx.forecolor = config.colorPallet[cc].getRGB();
		ctx.width = gvram.getBitmap().getWidth();
		ctx.height = gvram.getBitmap().getHeight();
		ctx.x = x;
		ctx.y = y;

		for(;;) {
			// ɒT
			int xl = searchPaintBorderLeft(ctx, ctx.x, ctx.y);
			// EɒT
			int xr = searchPaintBorderRight(ctx, ctx.x, ctx.y);
//			if(xr != ctx.x || xl != ctx.x) {
				// ͈͒oɐꍇ́C͈̔͂FILL
				for(int px = xl; px <= xr; px++) {
					gvram.vpoke(px, ctx.y, ctx.forecolor);
				}
//			}
			// ʒuT
			paint_find(ctx, xr, xl, 1);
			paint_find(ctx, xr, xl, -1);

			if(ctx.buf.empty()) {
				break;				// I
			}
			Point r = (Point)ctx.buf.pop();
			ctx.x = r.x;
			ctx.y = r.y;
		}
	}
	/**
	 * yCg̋EʒuɒTD
	 * @param cx JnX
	 * @param cy JnY
	 * @param bgcolor wiF
	 * @return Eʒu
	 */
	protected int searchPaintBorderLeft(PaintContext ctx, int cx, int cy) {
		int xx = -1;
		while(cx > 0) {
			cx += xx;
			int c = gvram.vpeek(cx, cy);
			if(c == ctx.forecolor || c != ctx.bgcolor) {
				cx -= xx;
				return cx;
			}
		}
		return cx;
	}
	/**
	 * yCg̋EʒuEɒT.
	 * @param cx JnX
	 * @param cy JnY
	 * @param bgcolor wiF
	 * @return Eʒu
	 */
	protected int searchPaintBorderRight(PaintContext ctx, int cx, int cy) {
		int xx = 1;
		while(cx < ctx.width -1) {
			cx += xx;
			int c = gvram.vpeek(cx, cy);
			if(c == ctx.forecolor || c != ctx.bgcolor) {
				cx -= xx;
				return cx;
			}
		}
		return cx;
	}
	public void paint_find(PaintContext ctx, int xr, int xl, int yy) {
		int height = ctx.height;
		int cy = ctx.y + yy;

		if(cy < 0 || cy >= height) {
			// Ȃ
			return;
		}
		int cx = xl;
		int ptr = -1;
		boolean scanning = true;
		while(cx <= xr) {
			int d = gvram.vpeek(cx, cy);
			if(d == ctx.forecolor || d != ctx.bgcolor) {
				// XLC̏I_ꍇC̈ʒuL^
				scanning = false;
				if(ptr >= 0) {
					// ۑ
					Point region = new Point(cx-1, cy);
					ctx.buf.push(region);
					ptr = -1;
				}
			} else {
				// cxyCgׂsNZ
				ptr = cx;
				scanning = true;
			}
			cx++;
		}
		if(scanning == true && ptr >= 0) {
			// XLɃyCgEzꍇ
			// EʒuL^
			Point region = new Point((cx-1), cy);
			ctx.buf.push(region);
		}
	}
	/**
	 * ~`悷D
	 * ~b`Fi[̃ASYɂ.
	 * @param x ~̒SXW
	 * @param y ~̒SYW
	 * @param r a
	 * @param scale XP[
	 * @param cc J[R[h
	 * @param lop _Zq
	 * @deprecated
	 */
	public void circle(int x, int y, int r, double scale, int cc, int lop) {
		int xx = r;
		int yy = 0;
		int f = -2 * r + 3;
		
		while(xx >= yy) {
			line(x + xx, y + yy, x + xx, y + yy, cc, lop);
			line(x - xx, y + yy, x - xx, y + yy, cc, lop);
			line(x + xx, y - yy, x + xx, y - yy, cc, lop);
			line(x - xx, y - yy, x - xx, y - yy, cc, lop);
			line(x + yy, y + xx, x + yy, y + xx, cc, lop);
			line(x - yy, y + xx, x - yy, y + xx, cc, lop);
			line(x + yy, y - xx, x + yy, y - xx, cc, lop);
			line(x - yy, y - xx, x - yy, y - xx, cc, lop);
		    if(f >= 0) {
		      xx--;
		      f -= 4 * xx;
		    }
		    yy++;
		    f += 4 * yy + 2;
		}
	}
	/**
	 * ȉ~`悷.
	 * ~b`Fi[̃ASYό`̂ɂ.
	 * @param cx ~̒SXW
	 * @param cy ~̒SYW
	 * @param r a
	 * @param ellipticity G(/c)
	 * @param cc J[R[h
	 * @param lop _Zq
	 */
	public void ellipse(int cx, int cy, int r, double ellipticity, int cc, int lop) {
		int a = r;
		int b = r;

		if(ellipticity > 1.0) {
			// c .. Ԃ
			a = (int)((double)a * (1.0 + (1.0 - ellipticity)));
		} else if(ellipticity < 1.0) {
			// 
			b = (int)((double)b * ellipticity);
		}
		
		if(a == 0 || b == 0) {
			return;
		}

		Point border = null;
		
		if(a >= b) {
			border = drawArcDownward(a, b, cx, cy, null, cc, lop);
			drawArcUpward(a, b, cx, cy, border, cc, lop);
		} else {
			border = drawArcUpward(a, b, cx, cy, null, cc, lop);
			drawArcDownward(a, b, cx, cy, border, cc, lop);
		}
	}
	/**
	 * ~ʂɕ`悷.
	 * @param a ȉ~ɊOڂ钷`̉̒
	 * @param b ȉ~ɊOڂ钷`̏c̒
	 * @param cx S_XW
	 * @param cy S_YW
	 * @param border E_̍W(null:)
	 * @param cc J[R[h
	 * @param lop _Zq
	 * @return E_̍W
	 */
	private Point drawArcDownward(int a, int b, int cx, int cy, Point border, int cc, int lop) {
		// at Red Line
		int x = a;
		int y = 0;
		int a2 = a * a;
		int b2 = b * b;
		int f = b2 * (-2 * x + 1) + 2 * a2;						// (4), (a,0) 
		int over = border != null ? border.y : x * b2 / a2;	// y ̍ŏIlAx ɂĕω

		while(y <= over) {
			pset(cx - x, cy - y, cc, lop);					// 
			pset(cx + x, cy - y, cc, lop);					// E
			pset(cx - x, cy + y, cc, lop);					// 
			pset(cx + x, cy + y, cc, lop);					// E

			if(f > 0) {
				f += b2 * (-4 * x + 4) + a2 * (4 * y + 6);	// (5) F2
				if(border == null || border.x < x) {
					x--;
				}
				if(border == null) {
					over = x * b2 / a2;
				}
			} else {
				f += a2 * (4 * y + 6);						// (5) F1
			}
			y++;
		}
		
		return new Point(x, y -1);
	}
	/**
	 * ~ʂɕ`悷.
	 * @param a ȉ~ɊOڂ钷`̉̒
	 * @param b ȉ~ɊOڂ钷`̏c̒
	 * @param cx S_XW
	 * @param cy S_YW
	 * @param border E_̍W(null:)
	 * @param cc J[R[h
	 * @param lop _Zq
	 * @return E_̍W
	 */
	private Point drawArcUpward(int a, int b, int cx, int cy, Point border, int cc, int lop) {
		// at Green Line
		int x = 0;
		int y = b;
		int a2 = a * a;
		int b2 = b * b;
		int f = 2 * b2 + a2 * (-2 * y + 1);						// (4), (0,b) 
		int over = border != null ? border.x : y * a2 / b2;

		while(x <= over) {
			pset(cx - x, cy - y, cc, lop);					// 
			pset(cx + x, cy - y, cc, lop);					// E
			pset(cx - x, cy + y, cc, lop);					// 
			pset(cx + x, cy + y, cc, lop);					// E

			if(f > 0) {
				f += b2 * (4 * x + 6) + a2 * (-4 * y + 4);	// (5) F2
				if(border == null || border.y < y) {
					y--;
				}
				if(border == null) {
					over = y  * a2 / b2;
				}
			} else {
				f += b2 * (4 * x + 6);						// // (5) F1
			}
			x++;
		}
		return new Point(x -1, y);
	}
	/**
	 * _`悷.
	 * @param x XW
	 * @param y YW
	 * @param cc J[R[h
	 * @param lop _Zq
	 */
	public void pset(int x, int y, int cc, int lop) {
		int bc = config.getColorCode(gvram.vpeek(x, y));
		int col = config.colorPallet[logicalOperation(bc, cc, lop)].getRGB();
		gvram.vpoke(x, y, col);
	}
	/**
	 * `悷D
	 * u[ñASYɂ.
	 * @param x1 n_XW
	 * @param y1 n_YW
	 * @param x2 I_XW
	 * @param y2 I_YW
	 * @param cc J[R[h
	 * @param lop _Zq
	 */
	public void line(int x1, int y1, int x2, int y2, int cc, int lop) {
		int sx = x1 > x2 ? -1 : 1;
		int sy = y1 > y2 ? -1 : 1;
		int xx = sx < 0 ? x1 - x2 : x2 - x1;
		int yy = sy < 0 ? y1 - y2 : y2 - y1;
		int x = x1;
		int y = y1;
		int e = 0;
		int[] buf = ((DataBufferInt)gvram.getBitmap().getRaster().getDataBuffer()).getData();
		int w = gvram.getBitmap().getWidth();
		int h = gvram.getBitmap().getHeight();

		if(xx >= yy) {
			// ̕y=ax+b̌Xa1̏ꍇ
			e = -xx;
			for(int i = 0; i <= xx; i++) {
				if(x >= 0 && y >= 0 && x < w && y < h) {
					// `͈͓̈̔ł΁Chbgu
					int bc = config.getColorCode(buf[y * w + x]);
					buf[y * w + x] = config.colorPallet[logicalOperation(bc, cc, lop)].getRGB();
				}
				x += sx;
				e += 2 * yy;
				if(e >= 0) {
					y += sy;
					e -= 2 * xx;
				}
			}
		} else {
			// ̕y=ax+b̌Xa1̏ꍇ
			e = -yy;
			for(int i = 0; i <= yy; i++) {
				if(x >= 0 && y >= 0 && x < w && y < h) {
					// `͈͓̈̔ł΁Chbgu
					int bc = config.getColorCode(buf[y * w + x]);
					buf[y * w + x] = config.colorPallet[logicalOperation(bc, cc, lop)].getRGB();
				}
				y += sy;
				e += 2 * xx;
				if(e >= 0) {
					x += sx;
					e -= 2 * yy;
				}
			}
		}
	}
	/**
	 * ``悷D
	 * @param sx n_XW
	 * @param sy n_YW
	 * @param dx I_XW
	 * @param dy I_YW
	 * @param cc J[R[h
	 * @param fill true:`̈hԂ / false:``̂
	 * @param lop _Zq
	 */
	public void box(int sx, int sy, int dx, int dy, int cc, boolean fill, int lop) {
		Graphics g = gvram.getBitmap().createGraphics();
		int[] buf = ((DataBufferInt)gvram.getBitmap().getRaster().getDataBuffer()).getData();
		int w = gvram.getBitmap().getWidth();
		int h = gvram.getBitmap().getHeight();

		if(sx > dx) {
			int[] d = NumberUtils.swap(sx, dx);
			sx = d[1];
			dx = d[0];
		}
		if(sy > dy) {
			int[] d = NumberUtils.swap(sy, dy);
			sy = d[1];
			dy = d[0];
		}
		
		g.setColor(config.colorPallet[cc]);

		if(fill == false) {
			// _Zw肳Ăꍇ
			int wl = dx;
			int hl = dy;
			wl = wl < w ? wl : w;
			hl = hl < h ? hl : h;
			
			// 
			for(int i = sx; i < wl + 1; i++) {
				if(sy >= 0) {
					int bc = config.getColorCode(buf[sy * w + i]);
					buf[sy * w + i] = config.colorPallet[logicalOperation(bc, cc, lop)].getRGB();
				}
				if(dy < h) {
					int bc = config.getColorCode(buf[dy * w + i]);
					buf[dy * w + i] = config.colorPallet[logicalOperation(bc, cc, lop)].getRGB();
				}
			}
			// c
			for(int i = sy; i < hl + 1; i++) {
				if(sx >= 0) {
					int bc = config.getColorCode(buf[i * w + sx]);
					buf[i * w + sx] = config.colorPallet[logicalOperation(bc, cc, lop)].getRGB();
				}
				if(dx < w) {
					int bc = config.getColorCode(buf[i * w + dx]);
					buf[i * w + dx] = config.colorPallet[logicalOperation(bc, cc, lop)].getRGB();
				}
			}
		} else {
			// _Zw肳Ăꍇ
			int wl = dx;
			int hl = dy;
			wl = wl < w ? wl : w;
			hl = hl < h ? hl : h;
			
			sy = sy < 0 ? 0 : sy;
			sx = sx < 0 ? 0 : sx;

			for(int y = sy; y < hl; y++) {
				for(int x = sx; x < wl; x++) {
					int bc = config.getColorCode(buf[y * w + x]);
					buf[y * w + x] = config.colorPallet[logicalOperation(bc, cc, lop)].getRGB();
				}
			}
		}

		g.dispose();
	}
	/**
	 * w肳ꂽFR[hmŘ_Zs.
	 * @param a ̐FR[h
	 * @param b `悷FR[h
	 * @param operator _Zq
	 * @return vZ(FR[h)
	 */
	private int logicalOperation(int a, int b, int operator) {
		int rc = 0;
		switch(operator) {
		case LOPR_AND:	rc = logicalOperationAnd(a, b); break;
		case LOPR_OR:	rc = logicalOperationOr(a, b); break;
		case LOPR_XOR:	rc = logicalOperationXor(a, b); break;
		case LOPR_NOT:	rc = logicalOperationNot(a); break;
		case LOPR_EQV:	rc = logicalOperationEqv(a, b); break;
		case LOPR_IMP:	rc = logicalOperationImp(a, b); break;
		case LOPR_NOP: rc = b; break;
		}

		// _Ẑ̂C4bit(=0`15)݂̂LƂ
		return rc & 15;
	}
	/**
	 * 2l̘_avZ.
	 * @param a 1
	 * @param b 2
	 * @return _a
	 */
	private int logicalOperationOr(int a, int b) {
		return a | b;
	}
	/**
	 * _ςvZ.
	 * @param a 1
	 * @param b 2
	 * @return _
	 */
	private int logicalOperationAnd(int a, int b) {
		return a & b;
	}
	/**
	 * rI_avZ.
	 * @param a 1
	 * @param b 2
	 * @return rI_a
	 */
	private int logicalOperationXor(int a, int b) {
		return a ^ b;
	}
	/**
	 * _lvZ.
	 * @param a 1
	 * @param b 2
	 * @return _l
	 */
	private int logicalOperationEqv(int a, int b) {
		return ~(a ^ b);
	}
	/**
	 * _܂vZ. 
	 * @param a 1
	 * @param b 2
	 * @return _
	 */
	private int logicalOperationImp(int a, int b) {
		return ~(a | b);
	}
	/**
	 * _ےvZ.
	 * @param a 
	 * @return _ے
	 */
	private int logicalOperationNot(int a) {
		return ~a;
	}
	/**
	 * _Zq̗\_ZR[hɕϊ.
	 * @param keyword \
	 * @return _ZR[h
	 */
	public static final int toLogicalOperationCode(String keyword) {
		Integer i = (Integer)LOPR_OPS_MAP.get(keyword);
		if(i == null) {
			return LOPR_NOP;
		} else {
			return i.intValue();
		}
	}
	/**
	 * yCgReLXg.
	 * @author satoshi akabane@logical-paradox.org
	 * @version $revision$
	 */
	static class PaintContext {
		public int width;
		public int height;
		public int forecolor;
		public int bgcolor;
		public int x;
		public int y;
		public Stack buf = new Stack();
	}
}
