/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: Window.java,v 1.1 2008/09/13 14:23:59 akabane Exp $
 */
package org.logical_paradox.common.swing;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferStrategy;

import javax.swing.JFrame;

/**
 * EBhE
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class Window {
	private final String title;
	private final WindowPanel wndpnl;
	private final int width;
	private final int height;
	/** t[ */
	private Frame mainFrm;
	/** EBhE\Ă邩ǂ */
	private boolean show = false;

	/** ftHg̃EBhEXi[ */
	private WindowListener defaultWindowListener;

	/**
	 * RXgN^
	 * @param name EBhE^Cg
	 * @param panel EBhE̒g
	 * @param w EBhẺTCY
	 * @param h EBhȄcTCY
	 */
	public Window(String name, WindowPanel panel, int w, int h) {
		title = name;
		wndpnl = panel;
		width = w;
		height = h;

		init();
	}
	/**
	 * 
	 */
	protected void init() {
		GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
		GraphicsDevice device = ge.getDefaultScreenDevice();
		GraphicsConfiguration gc = device.getDefaultConfiguration();

		if(wndpnl != null) {
			// plw肳ĂꍇCJFrame쐬
			JFrame jmainFrm = new JFrame(gc);
			jmainFrm.getContentPane().add(wndpnl);
			wndpnl.setParentFrame(jmainFrm);
			mainFrm = jmainFrm;
		} else {
			// plw肳ĂȂꍇCFrame쐬
			mainFrm = new Frame(gc);
		}

		mainFrm.setTitle(title);
		defaultWindowListener =	new WindowAdapter() {
						public void windowClosing(WindowEvent e) {
							System.exit(0);
						}
					};
		mainFrm.addWindowListener(defaultWindowListener);

		Dimension windowLocation = Toolkit.getDefaultToolkit().getScreenSize();
		mainFrm.setLocation(((int)windowLocation.getWidth() - width) /2, ((int)windowLocation.getHeight() - height) /2);
		mainFrm.setSize(new Dimension(width, height));
	}
	/**
	 * L[Xi[o^
	 * @param listener L[Xi[
	 */
	public void addKeyListener(KeyListener listener) {
		mainFrm.addKeyListener(listener);
	}
	/**
	 * TCY\ǂݒ肷D
	 * @param b true:TCY\ / false:TCYs\
	 */
	public void setResizable(boolean b) {
		mainFrm.setResizable(b);
	}
	/**
	 * ̃EBhẼobt@XgeW쐬ĕԂD
	 * @param size obt@TCY(ʏ2)
	 * @return 쐬ꂽobt@XgeW
	 */
	public BufferStrategy createBufferStrategy(int size) {
		mainFrm.setIgnoreRepaint(true);
		mainFrm.createBufferStrategy(size);

		return mainFrm.getBufferStrategy();
	}
	/**
	 * EBhE\
	 */
	public void setVisible(boolean b) {
		mainFrm.setVisible(b);
		show = b;
	}
	/**
	 * EBhE\Ă邩ǂԂ
	 * @return true:\Ă / false:\ĂȂ
	 */
	public boolean getVisible() {
		return show;
	}
	/**
	 * EBhEXi[ύXD
	 * EBhEN[YɉꍇɁCJX^Xi[o^Ă
	 * gpD
	 * @param lsnr o^郊Xi[
	 */
	public void changeWindowListener(WindowListener lsnr) {
		mainFrm.removeWindowListener(defaultWindowListener);
		mainFrm.addWindowListener(lsnr);
		defaultWindowListener = lsnr;
	}
}
