/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: PetitBasic.java,v 1.7 2008/11/28 14:51:51 akabane Exp $
 */
package org.logical_paradox.petitbasic;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

import org.logical_paradox.common.io.LoggingPrintStream;
import org.logical_paradox.petitbasic.runtime.BasicErrorMessage;
import org.logical_paradox.petitbasic.runtime.BasicRuntime;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * v`BASICD
 * Ȋœ삷邱Ƃz肵ĂCɃX[BASICꏈnD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.7 $
 */
public class PetitBasic {
	public static final String VERSION = "1.0.0";
	public static final String PROMPT = "- ";
	public static final String OK_PROMPT = "Ok";
	public static final String BREAK_PROMPT = "Break";
	public static final String LOG_FILENAME = "logs/petitbasic.log";

	/** EFJbZ[W */
	public static final String WELCOME_MSG =
				"Petit-BASIC version " + VERSION + "\r\n" +
				"Copyright (c)2006,2007,2008 satoshi akabane@logical-paradox.org\r\n" +
				"http://www.logical-paradox.org/\r\n" +
				"This program runs on a Java2 runtime environment 1.4.2 or later." +
				"\r\n";

	/** C^v^IbZ[W */
	public static final String SHUTDOWN_MSG = "\n\ninterpreter halted.";

	/**
	 * C\bhD
	 * BASICC^v^N܂D
	 * @param args vO
	 * @throws Exception ȂO
	 */
	public static final void main(String[] args) throws Exception {
		// fobOOo͊Jn
		PrintStream ps = new PrintStream(new FileOutputStream(LOG_FILENAME));
		BasicRuntime interpreter = new BasicRuntime(args, new LoggingPrintStream(ps));

		// ʂ̓͂󂯕t
		BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
		String line = null;
		boolean exitf = false;

		// JnbZ[W\
		System.out.println(WELCOME_MSG);
		do {
			System.out.print(PROMPT);
			System.out.flush();

			// ͑҂
			line = br.readLine();
			if(line.trim().toUpperCase().equals("EXIT")) {
				// ItO𗧂Ă
				exitf = true;
			} else {
				// 1ss
				int exitcode = -1;
				try {
					exitcode = interpreter.execute(System.out, line);
				} catch(BasicLanguageException e) {
					// G[̂ŃG[bZ[W\
					String errmsg = BasicErrorMessage.getMessage(e.getErrorCode());
					if(e.getLineno() >= 0) {
						// vOsɉ炩̃G[ꍇ́C̍sԍ\
						errmsg += " in " + e.getLineno();
					}
					System.out.println(errmsg + "\n");
				}
				// vO̎sfꂽC"Break"\
				if(exitcode == BasicRuntime.EXITC_EXEC_BREAK) {
					System.out.print(BREAK_PROMPT);
					int brokenLine = interpreter.getRuntimeEnvironment().getLastBrokenLine();
					if(brokenLine >= 0) {
						System.out.print(" in " + brokenLine);
					}
					System.out.println("");
				}
				// vO̎sC"Ok"\
				if(exitcode == BasicRuntime.EXITC_EXEC_LINE_OK || exitcode == BasicRuntime.EXITC_EXEC_BREAK) {
					System.out.println(OK_PROMPT);
				}
			}
		} while(exitf == false);

		// IbZ[W\
		System.out.println(SHUTDOWN_MSG);

		// fobOOo͂N[Y
		ps.close();
	}
}
