/*
 * $Id: Abs.java,v 1.5 2008/11/23 15:48:39 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.builtin;

import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.runtime.mathpack.Real;

/**
 * ABS֐D
 * <br><pre>
 * @\FɎw肳ꂽl̐ΒlԂD
 * ʁF֐<br>
 * FABS(<>)
 * ᕶFA=ABS(-0.009921)
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.5 $
 */
public class Abs implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		ctx.config.log.println("ABS֐sJn");

		Expression expression = new Expression(env, ctx, line, true);
		Token token = expression.eval();
		if(token == null || expression.isTerminated() == false) {
			// ɑ(=ɑ)ꍇ̓G[Ƃ
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR);
		}

		if(
			token.getValueType() == Token.VTYPE_STR ||
			(token.getValueType() == Token.VTYPE_DEF && env.getDefaultValueType() == Token.VTYPE_STR)
		) {
			// ^̂type mismatch
			throw new BasicLanguageException(ErrorCodeConstant.TYPE_MISMATCH);
		}

		Token answer = new Token(token);

		if(token.getValueType() == Token.VTYPE_INT) {
			// ̏ꍇ͐ŕԂ
			long value = token.getIntValue();
			answer.setIntValue(value < 0 ? -value : value);
		} else {
			// ̏ꍇmathpackʂ(xϊ͍sȂȂ)
			Real v = ctx.config.mathpack.fp_ABS(token.getRealValue());
			answer.setRealValue(v);
		}
		// ABS֐́Cl̐x͌p
		answer.setValueType(token.getValueType());
		answer.setDecimalFormat(token.getDecimalFormat());

		return answer;
	}

}
