/*
 * $Id: Asc.java,v 1.4 2008/11/13 18:27:22 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.builtin;

import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * ASC֐D
 * <br><pre>
 * @\FɎw肳ꂽ̃LN^R[hԂD
 * @@@2ȏ̕񂪗^ꂽꍇC2ڈȍ~͖D
 * ʁF֐<br>
 * FASC(<>)
 * ᕶFA=ASC("a")
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.4 $
 */
public class Asc implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		ctx.config.log.println("ASC֐sJn");

		Expression expression = new Expression(env, ctx, line, true);
		Token token = expression.eval();
		if(token == null || expression.isTerminated() == false) {
			// ɑ(=ɑ)ꍇ̓G[Ƃ
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR);
		}

		if(
			(token.getValueType() == Token.VTYPE_DEF && env.config.vartype != Token.VTYPE_STR) ||
			token.getValueType() != Token.VTYPE_STR
		) {
			throw new BasicLanguageException(ErrorCodeConstant.TYPE_MISMATCH, line.getLineno());
		}

		if(token.getStrValue().length() == 0) {
			throw new BasicLanguageException(ErrorCodeConstant.ILLEGAL_FUNCTION_CALL, line.getLineno());
		}

		char c = token.getStrValue().charAt(0);

		Token ans = new Token(Token.TYPE_LITERAL);
		ans.setValueType(Token.VTYPE_INT);
		ans.setDecimalFormat(Token.DF_INT);
		ans.setIntValue(c);

		return ans;
	}

}
