/*
 * $Id: Len.java,v 1.1 2008/10/08 18:23:24 akabane Exp $
 */
package org.logical_paradox.petitbasic.builtin;

import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * LEN֐D
 * <br><pre>
 * @\F̒ԂD
 * ʁF֐<br>
 * FLEN(<>)
 * ᕶFLEN(A$)
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class Len implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		Expression expr = new Expression(env, ctx, line, true);
		Token token = expr.eval();
		
		if(token == null || token.getType() != Token.TYPE_LITERAL || token.getValueType() != Token.VTYPE_STR) {
			throw new BasicLanguageException(ErrorCodeConstant.ILLEGAL_FUNCTION_CALL, line.getLineno());
		}
		
		int len = token.getStrValue().length();
		Token result = new Token(Token.TYPE_LITERAL);
		result.setValueType(Token.VTYPE_INT);
		result.setIntValue(len);
		result.setDecimalFormat(Token.DF_INT);
		
		return result;
	}

}
