/*
 * $Id: Rnd.java,v 1.1 2007/12/01 08:57:07 akabane Exp $
 */
package org.logical_paradox.petitbasic.builtin;

import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.runtime.mathpack.Real;

/**
 * RND֐D
 * <br><pre>
 * @\F0.0ȏ1.0̈l[𔭐D
 *      ̐̏ꍇC݂̗nňl[𔭐D
 *      ̐̏ꍇCw肳ꂽl_V[hƂāCnɈl[𔭐D
 * ʁF֐<br>
 * FRND(<>)
 * ᕶFA=RND(1)
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class Rnd implements BuiltinCommand {

	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		Expression expr = new Expression(env, ctx, line, true);
		Token token = expr.eval();
		if(token == null || expr.isTerminated() == false) {
			// syntax error
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
		}

		// 𐮐ɕϊ
		long value = OperationUtils.castValueType(token, Token.VTYPE_INT, ctx).getIntValue();
		
		// ̐w肳ꂽꍇC܂n
		if(value < 0) {
			value = -value;
			env.config.mathpack.fp_RANDOMIZE(Long.valueOf(value));
		}
		
		// l[̐
		Real random = env.config.mathpack.fp_RND();
		Token rc = new Token(Token.TYPE_LITERAL);
		rc.setValueType(Token.VTYPE_DBL);
		rc.setRealValue(random);

		return rc;
	}

}
