/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: Gosub.java,v 1.3 2006/11/06 14:04:59 akabane Exp $
 */
package org.logical_paradox.petitbasic.builtin.syntax;

import java.util.Stack;

import org.logical_paradox.petitbasic.builtin.BuiltinCommand;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.runtime.exception.FlowControlException;

/**
 * GOSUBD
 * <br><pre>
 * @\FTu[`Ăяo܂DTu[`́CRETURNɂĖ߂Ă邱Ƃł܂D
 * ʁFXe[gg<br>
 * FGOSUB <sԍ>
 * ᕶFGOSUB 200
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class Gosub implements BuiltinCommand {
	/** GOSUB`RETURN̖߂ۑpX^bN̈ */
	public static final String CTXKEY_GOSUB_STACK = "org.logical_paradox.putitbasic.builtin.Gosub.Stack";

	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		ctx.config.log.println("FORsJn");

		Stack calling = ctx.getCallingStructureContext(CTXKEY_GOSUB_STACK);
		if(calling.size() >= ctx.config.nestLimitGosubReturn) {
			// ȏGOSUB̃ReLXgJn邱Ƃ͂łȂ([v̉\)
			throw new BasicLanguageException(ErrorCodeConstant.GOSUB_WITHOUT_RETURN);
		}

		Expression expression = new Expression(env, ctx, line);
		Token subroutineLineno = expression.eval();

		if(subroutineLineno == null || subroutineLineno.getType() != Token.TYPE_LITERAL) {
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1);
		}
		int lineno = OperationUtils.intValue(subroutineLineno, ctx);

		// ߂̍쐬
		GosubReturnContext gosubContext = new GosubReturnContext();
		gosubContext.lineno = line.getLineno();
		gosubContext.runptr = line.getRunPtr();

		// Ăяo\ReLXgɕۑ
		calling.push(gosubContext);

		ctx.config.log.println("GOSUBI");

		// Tu[`Ăяo
		throw new FlowControlException(lineno);
	}

}
