/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: NumberProcessor.java,v 1.5 2008/06/04 17:32:21 akabane Exp $
 */
package org.logical_paradox.petitbasic.lex.fsm.number;

import org.logical_paradox.common.fsm.Symbol;
import org.logical_paradox.petitbasic.lex.SyntaxConstant;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.lex.fsm.AbstractProcessor;
import org.logical_paradox.petitbasic.lex.fsm.CharacterSymbol;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeConfig;

/**
 * l萔邽߂̗LԑJڋ@BD<br>
 * ȉ̂悤ȏ󂯓F
 * <li>1000</li>
 * <li>1000%</li>
 * <li>0.5</li>
 * <li>0.5#</li>
 * <li>.25!</li>
 * <li>1e+5</li>
 * <li>5.3121e-2</li>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.5 $
 */
public class NumberProcessor extends AbstractProcessor {
	/** ftHgvaluetype͎sɌ肳 */
	private int valueType = Token.VTYPE_DEF;
	/** ̓obt@ */
	private StringBuffer sb = new StringBuffer();
	/**  */
	private NumberState state = NumberState.INITIAL;
	/** BASIC^CRtBO */
	private final BasicRuntimeConfig config;
	/**
	 * RXgN^D
	 * @param name ԑJڋ@B̎ʖ
	 * @param cfg BASIC^CRtBO
	 * @throws Exception ȂO
	 */
	public NumberProcessor(String name, BasicRuntimeConfig cfg) throws Exception {
		super(name);
		config = cfg;
	}

	/**
	 * ͋LԂɑ΂ė^
	 * ͂ꂽLɂāCԂJڂƂ^C~OŃCxg
	 * @param symbol ͋L
	 */
	protected void input(Symbol symbol) {
		if(state == NumberState.ERROR || state == NumberState.FINISH) {
			// G[ȂɏIĂꍇ͉Ȃ
			return;
		}
		CharacterSymbol character = (CharacterSymbol)symbol;
		char c = character.getCharacter();
		switch(c) {
			// 
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				if(state == NumberState.EXPRSIGN) {
					// w\LL'e'̒̏ꍇ͍\G[
					state = NumberState.ERROR;
					rollback();
				} else {
					if(state == NumberState.INITIAL) {
						state = NumberState.INTEGER;
					}
					sb.append(c);
				}
				break;
			// 
			case '+':
			case '-':
				if(state == NumberState.INTEGER || state == NumberState.DECIMAL) {
					// ܂͎̒̏ꍇ͎Ȃ̂łŏI
					state = NumberState.FINISH;
				}
				if(state != NumberState.INITIAL && state != NumberState.EXPRSIGN) {
					// 擪܂͎w\LL'e'̒łȂꍇ͉ZqƂĂ'+'
					state = NumberState.FINISH;
					rollback();
				} else {
					if(state == NumberState.INITIAL) {
						// 擪ɕĂ̂ŁC̏Ԃ͐擾
						state = NumberState.INTEGER;
					} else {
						// w\LL'e'̒ゾ̂ŁC̏Ԃ͎w擾
						state = NumberState.POW;
					}
					sb.append(c);
				}
				break;
			// w\L
			case 'E':
			case 'e':
				if(state != NumberState.DECIMAL && state != NumberState.INTEGER) {
					state = NumberState.ERROR;
					rollback();
				} else {
					state = NumberState.EXPRSIGN;
					sb.append(c);
				}
				break;
			case '.':
				// _
				if(state != NumberState.INITIAL && state != NumberState.INTEGER) {
					// 擪܂͐̒łȂꍇ̓G[
					state = NumberState.ERROR;
					rollback();
				} else {
					if(state == NumberState.INITIAL) {
						// Ԃ̏ꍇC'0'ɒǉĂ
						sb.append('0');
					}
					sb.append(c);
					state = NumberState.DECIMAL;
				}
				break;
			// Pxw
			case SyntaxConstant.C_VTYPE_SGL:
				valueType = Token.VTYPE_SGL;
				state = NumberState.FINISH;
				break;
			// {xw
			case SyntaxConstant.C_VTYPE_DBL:
				valueType = Token.VTYPE_DBL;
				state = NumberState.FINISH;
				break;
			// w
			case SyntaxConstant.C_VTYPE_INT:
				valueType = Token.VTYPE_INT;
				state = NumberState.FINISH;
				break;
			// I
			default:
				state = NumberState.FINISH;
				rollback();
		}
	}
	/**
	 * ݂̏ԂIԂɂ邩ǂԂ
	 * @return true:I / false:p
	 */
	protected boolean isFiniteState() {
		return state == NumberState.FINISH || state == NumberState.ERROR;
	}

	/**
	 * ԑJڋ@BXLf[^ԂD
	 * e(valuetype=Px/{x/)̃g[NԂD
	 * @return XLꂽf[^
	 */
	public Object getResult() {
		Token token = new Token(Token.TYPE_LITERAL);
		token.setValueType(valueType);

		// l̑
		OperationUtils.setValue(config, token, sb.toString());

		return token;
	}
}
