/*
 * $Id: OperatorProcessor.java,v 1.1 2006/09/28 17:20:23 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.lex.fsm.ope;

import org.logical_paradox.common.fsm.Symbol;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.lex.fsm.AbstractProcessor;
import org.logical_paradox.petitbasic.lex.fsm.CharacterSymbol;

/**
 * Zq邽߂̗LԑJڋ@BD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class OperatorProcessor extends AbstractProcessor {
	/** 荞ݗp̃obt@ */
	private StringBuffer sb = new StringBuffer();
	/** ǂݎ */
	private OperatorState state = OperatorState.INITIAL;

	/**
	 * RXgN^D
	 * @param name ʎq
	 * @throws Exception CX^XɎs
	 */
	public OperatorProcessor(String name) throws Exception {
		super(name);
	}
	/**
	 * ԑJڋ@Bɑ΂āC͋LǉD
	 * @param symbol ͋L
	 */
	protected void input(Symbol symbol) {
		if(isFiniteState()) {
			// ɏIԂ֑JڂĂ邽߁CȂ
			return;
		}
		CharacterSymbol cs = (CharacterSymbol)symbol;
		char c = Character.toUpperCase(cs.getCharacter());

		switch(c) {
			case '+':		// Z
			case '-':		// Z
			case '*':		// Z
			case '/':		// Z
			case '^':		// ׂ
			case '\\':		// Z
				if(state == OperatorState.INITIAL) {
					sb.append(c);
				} else {
					rollback();
				}
				state = OperatorState.FINISH;
				break;
			case '=':
				if(state == OperatorState.INITIAL || state == OperatorState.OPERATOR_SCANNING) {
					sb.append(c);
					state = OperatorState.FINISH;
				} else {
					rollback();
					state = OperatorState.ERROR;
				}
				break;
			case '>':
				if(state == OperatorState.INITIAL) {
					sb.append(c);
					state = OperatorState.OPERATOR_SCANNING;
				} else if(state == OperatorState.OPERATOR_SCANNING && "<".equals(sb.toString())) {
					// <>̏ꍇ
					sb.append(c);
					state = OperatorState.FINISH;
				} else {
					rollback();
					state = OperatorState.ERROR;
				}
				break;
			case '<':
				if(state == OperatorState.INITIAL) {
					sb.append(c);
					state = OperatorState.OPERATOR_SCANNING;
				} else {
					rollback();
					state = OperatorState.ERROR;
				}
				break;
			default:
				// \ȂLN^̂ŏI
				rollback();
				state = OperatorState.FINISH;
		}
	}
	/**
	 * IԂ𔻒肷D
	 * @return true:I / false:p
	 */
	protected boolean isFiniteState() {
		return state == OperatorState.FINISH || state == OperatorState.ERROR;
	}
	/**
	 * ԑJڋ@BXLf[^ԂD
	 * e(valuetype=)̃g[NԂD
	 * @return XLꂽf[^
	 */
	public Object getResult() {
		if(sb == null || sb.length() == 0) {
			return null;
		}
		Token token = new Token(Token.TYPE_OPERATOR);
		token.setStrValue(sb.toString());
		
		return token;
	}

}
