/*
 * $Id: StandardScanner.java,v 1.1 2007/12/26 16:40:14 akabane Exp $
 */
package org.logical_paradox.petitbasic.lex.scanner;


/**
 * PetitBASIC̕WXLiD
 * @author satoshi akabane@logical-paradox.org
 * @version $revision$
 */
public class StandardScanner implements Scanner {
	/** eXgp^[ - 萔 */
	public static final String TEST_PTN_STRING_LITERAL = "\"";
	/** eXgp^[ - l萔 */
	public static final String TEST_PTN_NUMBER_LITERAL = "[0-9.]";
	/** eXgp^[ - \܂͕ϐ */
	public static final String TEST_PTN_RESERVED_OR_VARNAME = "[a-zA-Z]";
	/** eXgp^[ - Rg */
	public static final String TEST_PTN_COMMENT = "'";
	/** eXgp^[ -  */
	public static final String TEST_PTN_BRACKET = "[()]";
	/** eXgp^[ - Zq */
	public static final String TEST_PTN_OPERATOR = "[\\^\\+\\*/\\\\=\\-><]";
	/** eXgp^[ - w萮 */
	public static final String TEST_PTN_RADIXED_INT = "&";
	/** eXgp^[ - f~^ */
	public static final String TEST_PTN_DELIMITER = "[;:]";
	/** eXgp^[ -  */
	public static final String TEST_PTN_WHITESPC = "[\t ]";
	/** eXgp^[ - sL */
	public static final String TEST_PTN_ENDMARK = "[\\r\\n]";

	/** eXgp^[ */
	private static final TestPattern[] testPatterns = new TestPattern[] {
		new TestPattern(TEST_PTN_STRING_LITERAL, Scanner.LANG_STRING_LITERAL),
		new TestPattern(TEST_PTN_OPERATOR, Scanner.LANG_OPERATOR),
		new TestPattern(TEST_PTN_NUMBER_LITERAL, Scanner.LANG_NUMBER_LITERAL),
		new TestPattern(TEST_PTN_RESERVED_OR_VARNAME, Scanner.LANG_RESERVED_OR_VARNAME),
		new TestPattern(TEST_PTN_COMMENT, Scanner.LANG_COMMENT),
		new TestPattern(TEST_PTN_RADIXED_INT, Scanner.LANG_RADIXED_INT),
		new TestPattern(TEST_PTN_BRACKET, Scanner.LANG_BRACKET),
		new TestPattern(TEST_PTN_DELIMITER, Scanner.LANG_DELIMITER),
		new TestPattern(TEST_PTN_WHITESPC, Scanner.LANG_WHITE_SPC),
		new TestPattern(TEST_PTN_ENDMARK, Scanner.LANG_ENDMARK)
	};
	/**
	 * ͋L].
	 * @param input ͋L
	 * @return ]l
	 */
	public int test(String input) {
		// eXg
		for(int i = 0; i < testPatterns.length; i++) {
			if(input.matches(testPatterns[i].testPattern)) {
				return testPatterns[i].result;
			}
		}

		// ̃p^[ɂvȂꍇ
		return Scanner.LANG_UNDEFINED;
	}
}
