/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: BasicCommandLine.java,v 1.9 2007/03/05 09:48:30 akabane Exp $
 */
package org.logical_paradox.petitbasic.runtime;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.logical_paradox.petitbasic.lex.SyntaxConstant;
import org.logical_paradox.petitbasic.lex.Token;

/**
 * BASICR}hs
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.9 $
 */
public class BasicCommandLine {
	/** s|C^ - 擪 */
	public static final int RUNPTR_BEGIN = -1;

	/** valuetype - ^Cqϊ}bv */
	private static final Map vtypemap;
	/** radixtype - wqϊ}bv */
	private static final Map radixmap;

	static {
		// ^Cq
		HashMap map = new HashMap();
		map.put("" + Token.VTYPE_SGL, "" + SyntaxConstant.C_VTYPE_SGL);
		map.put("" + Token.VTYPE_DBL, "" + SyntaxConstant.C_VTYPE_DBL);
		map.put("" + Token.VTYPE_INT, "" + SyntaxConstant.C_VTYPE_INT);
		map.put("" + Token.VTYPE_STR, "" + SyntaxConstant.C_VTYPE_STR);
		map.put("" + Token.VTYPE_DEF, "");

		vtypemap = Collections.unmodifiableMap(map);

		// wq
		HashMap radix = new HashMap();
		radix.put("" + Token.DF_BIN, "&B");
		radix.put("" + Token.DF_OCT, "&O");
		radix.put("" + Token.DF_HEX, "&H");

		radixmap = Collections.unmodifiableMap(radix);
	}

	/** sʒu|C^ */
	private int runptr = -1;
	/**  */
	private Token[] tokens;
	/** sԍ */
	private int lineno;

	/**
	 * RXgN^D
	 * @param lno sԍ
	 * @param tks 僊Xg
	 */
	public BasicCommandLine(int lno, Token[] tks) {
		tokens = tks;
		lineno = lno;
	}
	/**
	 * 僊XgԂD
	 * @return 僊Xg
	 */
	public Token[] getTokens() {
		return tokens;
	}
	/**
	 * sԍԂD
	 * @return sԍ
	 */
	public int getLineno() {
		return lineno;
	}
	/**
	 * sԍݒ肷D
	 * @param lno sԍ
	 */
	public void setLineno(int lno) {
		lineno = lno;
	}
	/**
	 * ɉ߂ׂԂD
	 * @return 
	 */
	public Token getNextToken() {
		runptr++;
		if(tokens.length == runptr) {
			// Ȃ(|C^͏I[ŌŒ肷)
			runptr--;
			return null;
		} else {
			return tokens[runptr];
		}
	}
	/**
	 * ɉ߂ׂLȎԂD
	 * white space͖D
	 * @return 
	 */
	public Token getNextValidToken() {
		skipWhiteSpace();
		return getNextToken();
	}
	/**
	 * ɉ߂ׂLȎԂD
	 * getNextValidToken()Ƃ̈Ⴂ́CtFb`Ƀ|C^𓮂Ȃ_łD
	 * @return 
	 */
	public Token peekNextValidToken() {
		int ptr = runptr;
		Token token = getNextValidToken();
		runptr = ptr;
		
		return token;
	}
	/**
	 * ǎ\ȃg[N邩ǂԂD
	 * @return true: / false:Ȃ
	 */
	public boolean hasMoreTokens() {
		return runptr < tokens.length-1;
	}
	/**
	 * ǎ|C^1߂D
	 * ǂ݂ꍇȂǂɎgpD
	 */
	public void rewind() {
		if(runptr >= 0) {
			runptr--;
		}
	}
	/**
	 * 󔒂XLbvD
	 */
	public void skipWhiteSpace() {
		Token token = null;
		do {
			token = getNextToken();
		} while(token != null && " ".equals(token.getStrValue()));

		if(token != null && runptr > -1) {
			// 肷̂Ŗ߂
			runptr--;
		}
	}
	/**
	 * sʒu|C^ݒ肷D
	 * ݒɂ͏\ɒӂ邱ƁD
	 * @param ptr sʒu|C^
	 */
	public void setRunPtr(int ptr) {
		runptr = ptr;
	}
	/**
	 * ݂̎sʒu|C^ԂD
	 * @return ݂̎sʒu|C^
	 */
	public int getRunPtr() {
		return runptr;
	}
	/**
	 * s|C^D
	 * s擪sꍇCK̏ĂяoƁD
	 */
	public void clearRunptr() {
		runptr = -1;
	}
	/**
	 * BASICR}hsoCgɕϊD
	 * <pre>
	 * +00  sԍ(.4b)
	 * +04  vOoCg(.4b)
	 * +08  BASICvO(oCg)
	 * 
	 * Sbig endianŋL^
	 * </pre>
	 * @return oCg
	 */
	public byte[] getBytes() {
		String basicProgramText = toString();

		return basicProgramText.getBytes();
	}
	/**
	 * ̃vOs̕\ԂD
	 * 傩BASICeLXg𕜌D<br>
	 * ꂽBASICeLXǵCēx͂ɂ邱ƂŁCvO<br>
	 * 邱ƂłD
	 * @return BASICeLXg
	 */
	public String toString() {
		StringBuffer sb = new StringBuffer();
		// sԍ̏o
		sb.append("" + getLineno() + " ");
		Token[] tokens = getTokens();

		// g[N̏o
		for(int i = 0; i < tokens.length; i++) {
			switch(tokens[i].getType()) {
				// 萔
				case Token.TYPE_LITERAL:
					if(tokens[i].getValueType() != Token.VTYPE_STR) {
						// l^
						sb.append(tokens[i].toString());
					} else {
						// ^
						sb.append("\"" + tokens[i].getStrValue() + "\"");
					}
					break;
				// Rg
				case Token.TYPE_COMMENT: sb.append("'" + tokens[i].getStrValue()); break;
				// ϐ
				case Token.TYPE_VARIABLE: sb.append(tokens[i].getStrValue() + vtypemap.get("" + tokens[i].getValueType())); break;
				default:
					String radixModifier = (String)radixmap.get("" + tokens[i].getDecimalFormat());
					sb.append(radixModifier == null ? "" : radixModifier);
					sb.append(tokens[i].getStrValue());
			}
		}
		
		return sb.toString();
	}
	/**
	 * srD
	 * Pɍsԍňv邩ǂr邾ƂD
	 * @param o rΏ
	 * @return true: / false:Ⴄ
	 */
	public boolean equals(Object o) {
		BasicCommandLine line = (BasicCommandLine)o;

		return lineno == line.lineno;
	}
	/**
	 * nbVR[hԂD
	 * sԍƓ̂Ƃ
	 * @return nbVR[h
	 */
	public int hashCode() {
		return lineno;
	}
}
