/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: Expression.java,v 1.26 2008/11/27 17:09:51 akabane Exp $
 */
package org.logical_paradox.petitbasic.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

import org.logical_paradox.petitbasic.BuiltinCommandLibrary;
import org.logical_paradox.petitbasic.builtin.BuiltinCommand;
import org.logical_paradox.petitbasic.lex.SyntaxConstant;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.Operation;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.var.Variable;

/**
 * vZbTD
 * lXȎ]Cʂg[Ň`ŕԋpD<br>
 * ̍ۂɁCBASICvO̎s|C^ړD<br>
 * ̕]́Ct|[hL@(reverse polish notation)ɂčsD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.26 $
 */
public class Expression {
	/** BASIC^C */
	private final BasicRuntimeEnvironment env;
	/** BASIC^CReLXg */
	private final BasicRuntimeContext ctx;
	/** BASICR}hC */
	private final BasicCommandLine line;
	/** Zq̗D揇ʃ}bv */
	private static final Map priorityMap;
	/** ZqpX^bN */
	private Stack operatorStack = null;
	/** lX^bN */
	private Stack valueStack = null;
	/** ʃlXgx */
	private int bracketNestLevel = 0;

	/** ֐[h(tru:֐[h / false:ʏ̎][h) */
	private boolean funcproc = false;
	/** ̉͂rŒfǂ(true: / false:ĂȂ) */
	private boolean remain = true;
	/** ̎vZbTŎ] */
	private int evalCount = 0;

	/*
	 * X^eBbNCjVCU
	 * ZqD揇ʃ}bv
	 */
	static {
		HashMap map = new HashMap();
		// Zq
		map.put(SyntaxConstant.S_OPR_POW, new Integer(SyntaxConstant.OPR_POW));		// ׂ
		map.put(SyntaxConstant.S_OPR_PLS, new Integer(SyntaxConstant.OPR_PLUS));	// Z
		map.put(SyntaxConstant.S_OPR_MNS, new Integer(SyntaxConstant.OPR_MINUS));	// Z
		map.put(SyntaxConstant.S_OPR_DIV, new Integer(SyntaxConstant.OPR_DIV));		// Z
		map.put(SyntaxConstant.S_OPR_MUL, new Integer(SyntaxConstant.OPR_MUL));		// Z
		map.put(SyntaxConstant.S_OPR_DVI, new Integer(SyntaxConstant.OPR_DIVI));	// Z
		map.put(SyntaxConstant.S_OPR_FNC, new Integer(SyntaxConstant.OPR_FUNC));	// ֐
		map.put(SyntaxConstant.S_OPR_MSN, new Integer(SyntaxConstant.OPR_M_SIGN));	// }CiX
		map.put(SyntaxConstant.S_OPR_PSN, new Integer(SyntaxConstant.OPR_P_SIGN));	// vX
		map.put(SyntaxConstant.S_OPR_MOD, new Integer(SyntaxConstant.OPR_MOD));		// ]Z
		// ֌WZq
		map.put(SyntaxConstant.S_ROPR_EQ, new Integer(SyntaxConstant.ROPR_EQ));		// 
		map.put(SyntaxConstant.S_ROPR_LT, new Integer(SyntaxConstant.ROPR_LT));		// 
		map.put(SyntaxConstant.S_ROPR_GT, new Integer(SyntaxConstant.ROPR_GT));		// 
		map.put(SyntaxConstant.S_ROPR_LE, new Integer(SyntaxConstant.ROPR_LE));		// 
		map.put(SyntaxConstant.S_ROPR_GE, new Integer(SyntaxConstant.ROPR_GE));		// 
		map.put(SyntaxConstant.S_ROPR_NE, new Integer(SyntaxConstant.ROPR_NE));		// 
		// _Zq
		map.put(SyntaxConstant.S_LOPR_NOT, new Integer(SyntaxConstant.LOPR_NOT));	// NOT
		map.put(SyntaxConstant.S_LOPR_AND, new Integer(SyntaxConstant.LOPR_AND));	// AND
		map.put(SyntaxConstant.S_LOPR_OR, new Integer(SyntaxConstant.LOPR_OR));		// OR
		map.put(SyntaxConstant.S_LOPR_XOR, new Integer(SyntaxConstant.LOPR_XOR));	// XOR
		map.put(SyntaxConstant.S_LOPR_IMP, new Integer(SyntaxConstant.LOPR_IMP));	// IMP
		map.put(SyntaxConstant.S_LOPR_EQV, new Integer(SyntaxConstant.LOPR_EQV));	// EQV

		priorityMap = Collections.unmodifiableMap(map);
	}

	/**
	 * RXgN^D
	 * @param e BASIC^C
	 * @param c BASIC^CReLXg
	 * @param bcl BASICR}hC
	 */
	public Expression(BasicRuntimeEnvironment e, BasicRuntimeContext c, BasicCommandLine bcl) {
		env = e;
		ctx = c;
		line = bcl;
	}
	/**
	 * RXgN^D
	 * @param e BASIC^C
	 * @param c BASIC^CReLXg
	 * @param bcl BASICR}hC
	 * @param mode [h(true:֐[h / false:Xe[gg)
	 */
	public Expression(BasicRuntimeEnvironment e, BasicRuntimeContext c, BasicCommandLine bcl, boolean mode) {
		this(e, c, bcl);
		funcproc = mode;
	}
	/**
	 * ϐD
	 */
	protected void init() {
		// ]pX^bN̏
		operatorStack = new Stack();
		valueStack = new Stack();
		// ʃlXgx = 0
		bracketNestLevel = 0;
	}
	/**
	 * ]D
	 * @return ]
	 * @throws BasicLanguageException ^CG[
	 */
	public Token eval() throws BasicLanguageException {
		// O
		preEvaluation();

		// ݑΉ̃g[N
		Token token = null;
		// [vtO
		boolean loop = true;

		try {
			// g[N̓[v
			boolean belowsLiteral = false;
			int belowsOperator = 0;
			while(loop && (token = line.getNextToken()) != null) {
				debugOutStack();
				switch(token.getType()) {
					// 萔(萔͂̂܂܏o)
					case Token.TYPE_LITERAL:
						valueStack.push(token);
						belowsLiteral = true;
						belowsOperator = 0;
						break;
					// Zq
					case Token.TYPE_OPERATOR:
						//   ZqIuWFNg̕ϊ
						Operator o = getOperator(token, belowsLiteral == false);

						if(belowsOperator >= 2 || (belowsOperator == 1 && !o.needOnlySingleOperand())) {
							// Zq̒ɂȂ艉Zqꍇ͍\G[Ƃ
							// PZqɂ͂̐KpȂ
							throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
						}

						doOperation(o);
						belowsLiteral = false;
						belowsOperator++;
						break;
					// LN^
					case Token.TYPE_CHARACTER:
						if(/*funcproc == true && */",".equals(token.getStrValue())) {
							// J}̏ꍇ͒f
							remain = true;/*funcproc*//*true*/;		// 20090830 COLOR߂܂삵Ȃߖ߂
							if(!funcproc) {
								// ֐[hłȂꍇCJ}ǂ݂̂Ŗ߂
								line.rewind();
							}
							loop = false;
						} else if(!" ".equals(token.getStrValue())) {
							// 󔒈ȊÕLN^͔F߂Ȃ
							throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
						}
						belowsOperator = 0;
						break;
					// f~^܂͒߂܂̓ubN
					case Token.TYPE_DELIMITER:
					case Token.TYPE_COMMENT:
					case Token.TYPE_BLOCK:
						line.rewind();			// |C^f~^(܂̓Rg)悤ɖ߂
						loop = false;
						token = null;
						break;
					// 
					case Token.TYPE_BRACKET:
						if((""+SyntaxConstant.C_BRACKET_LEFT).equals(token.getStrValue())) {
							// ʃxAbv
							bracketNestLevel++;
						} else {
							// ʃx_E
							if(funcproc == false || bracketNestLevel > 0) {
								bracketNestLevel--;
							} else {
								// ֐s̏ꍇ')'ŏI(ʂŏIꍇ͕͂s\ł)
								loop = false;
								remain = false;
								token = null;
							}
						}
						belowsOperator = 0;
						belowsLiteral = false;
						break;
					// \
					case Token.TYPE_RESERVED_WORD:
						switch(token.getFuncType()) {
							// ֐܂̓VXeϐ
							case Token.RTYPE_FNC:
							case Token.RTYPE_VAR:
								// ֐̏ꍇC݂̉̓|Cgx[XƂĊ֐N
								executeFunction(token);
								break;
							// ꉉZq
							case Token.RTYPE_OPR:
								//   ZqIuWFNg̕ϊ
								Operator ro = getOperator(token, belowsLiteral == false);
								doOperation(ro);
								break;
							default:
								line.rewind();
								loop = false;
								token = null;
						}
						belowsLiteral = true;
						belowsOperator = 0;
						break;
					// ϐ(ϐ͓e擾Ē萔Ƃďo)
					case Token.TYPE_VARIABLE:
						Token value = restoreVariable(token);
						valueStack.push(value);
						belowsLiteral = true;
						belowsOperator = 0;
						break;
					default:
						throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
				}
			}

			// SẲZqIꍇCZqX^bNɎcĂ̂ɂďԂɏ
			while(operatorStack.empty() == false) {
				doOperation(null);
			}

			// SẲZqʁCŏIIɃX^bNɎcĂg[NvZʂł
			if(valueStack.size() > 1) {
				// (vZʂ)
				throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
			} else if(valueStack.empty() == false) {
				// ߂l̂łԂ
				token = (Token)valueStack.pop();
			}
			debugOutStack();

			if(bracketNestLevel != 0 || (funcproc && remain && token == null)) {
				// ʂ̑Ή̂ŕ@G[
				throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR);
			}
			
			if(line.hasMoreTokens() == false) {
				remain = false;
			}
			return token;
		} catch(BasicLanguageException be) {
			// sԍ㏑čēxX[
			be.setLineno(line.getLineno());
			throw be;
		}
	}
	/**
	 * w肳ꂽɑΉ鉉ZqIuWFNgԂD
	 * @param token g[N
	 * @param alone true:PZq / false:2Zq(3Zq̓T|[gO)
	 * @return ϊꂽZqIuWFNg
	 * @throws BasicLanguageException vZɉ炩̗O
	 */
	protected Operator getOperator(Token token, boolean alone) throws BasicLanguageException {
		// ZqIuWFNgɕϊ
		String op = getOperatorName(token, alone);
		if(op.equals(token.getStrValue()) == false) {
			token = new Token(token);
			token.setStrValue(op);
		}

		Integer prio = (Integer)priorityMap.get(op);
		if(prio == null) {
			throw new BasicLanguageException(ErrorCodeConstant.INTERNAL_ERROR, line.getLineno());
		}
		Operator o = new Operator(token, prio.intValue() - (bracketNestLevel * SyntaxConstant.MAX_DEF_OPERATORS));
		
		return o;
	}
//	/**
//	 * ZqsD
//	 * <li>ZqX^bNɉȂꍇ͏̉ZqvbV</li>
//	 * <li>X^bNgbv̉Zq̗D揇ʂ菈̉Zq̗D揇ʂꍇCX^bNɃvbV</li>
//	 * <li>X^bNgbv̉Zq̗D揇ʂ菈̉Zq̗D揇ʂႢꍇC
//	 * X^bN̗D揇ʂ̍ZqSĎs</li>
//	 * @param token g[N
//	 * @param alone true:PZq / false:2Zq(3Zq̓T|[gO)
//	 * @throws BasicLanguageException vZɉ炩̗O
//	 */
//	protected void doOperation(Token token, boolean alone) throws BasicLanguageException {
//		// ZqIuWFNgɕϊ
//		String op = getOperatorName(token, alone);
//		if(op.equals(token.getStrValue()) == false) {
//			token = new Token(token);
//			token.setStrValue(op);
//		}
//
//		Integer prio = (Integer)priorityMap.get(op);
//		if(prio == null) {
//			throw new BasicLanguageException(ErrorCodeConstant.INTERNAL_ERROR, line.getLineno());
//		}
//		Operator o = new Operator(token, prio.intValue() - (bracketNestLevel * SyntaxConstant.MAX_DEF_OPERATORS));
//
//		doOperation(o);
//	}
	/**
	 * ZqsD
	 * <li>ZqX^bNɉȂꍇ͏̉ZqvbV</li>
	 * <li>X^bNgbv̉Zq̗D揇ʂ菈̉Zq̗D揇ʂꍇCX^bNɃvbV</li>
	 * <li>X^bNgbv̉Zq̗D揇ʂ菈̉Zq̗D揇ʂႢꍇC
	 * X^bN̗D揇ʂ̍ZqSĎs</li>
	 * @param o Zq
	 * @throws BasicLanguageException vZɉ炩̗O
	 */
	protected void doOperation(Operator o) throws BasicLanguageException {
		// ZqX^bN̐擪̉ZqƁCx̉Zq̗D揇ʂr
		// ɉ炩̉Zq݂ꍇ́CZqX^bÑgbvɔzuĂ
		// Zq̗D揇ʂƔr
		// ̉ZqD揇ʂ̍ZqX^bN疳Ȃ܂ŌvZ
		while(operatorStack.empty() == false) {
			debugOutStack();
			Operator now = (Operator)operatorStack.peek();
			if(o != null && now.priority > o.priority) {
				break;
			}
			// ZqX^bN̈ԏォ1Zq擾
			if(operatorStack.isEmpty()) {
				throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
			}
			now = (Operator)operatorStack.pop();

			// Zq̎s
			if(valueStack.isEmpty()) {
				throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
			}
			Token second = (Token)valueStack.pop();

			Token first = null;
			if(now.needOnlySingleOperand() == false) {
				if(valueStack.isEmpty()) {
					throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
				}
				// 񍀉Zq̏ꍇ̂݁CPlX^bN擾
				first = (Token)valueStack.pop();
			}

			Token result = null;
			if(now.isFunction()) {
				// ֐(ɏʂ̂͂)
				throw new BasicLanguageException(ErrorCodeConstant.INTERNAL_ERROR, line.getLineno());
			} else if(now.isLogicalOperator()) {
				// _Zq
				Operation opr = BuiltinCommandLibrary.getInstance().getOperationOf(now.funcname);
				result = opr.doOperation(ctx, first, second);
			} else {
				// ʏ̉Zq
				Operation opr = null;
				if(now.funcname != null) {
					// \Ƃēo^Ă
					opr = BuiltinCommandLibrary.getInstance().getOperationOf(now.operator); 
				} else {
					// ZqƂēo^Ă
					opr = OperatorLibrary.getInstance().getOperationOf("[" + now.operator + "]"); 
				}
				result = opr.doOperation(ctx, first, second);
			}

			// vZʂlX^bNփvbV
			if(result != null) {
				valueStack.push(result);
			}
		}
		// Ň_@ƂȂ鉉Zqw肳Ăꍇ́CZqX^bNɐς
		if(o != null) {
			operatorStack.push(o);
		}
	}
	/**
	 * ֐sD
	 * @param token \(֐)̃g[N
	 * @throws BasicLanguageException ֐sɔO
	 */
	protected void executeFunction(Token token) throws BasicLanguageException {
		// ֐nhI
		BuiltinCommand command = BuiltinCommandLibrary.getInstance().getCommandOf(token.getStrValue());
		// ֐nhs
		Token answer = command.execute(env, ctx, line);

		if(answer != null) {
			// ֐̌ʂꍇClX^bNɃvbV
			// BASICߍs̃|C^́C֐̎̈ʒu|CgĂ͂(I[JbR̎̈ʒu)
			valueStack.push(answer);
		}
	}
	/**
	 * ϐ̓e𕜌D
	 * @param token g[N(ϐ)
	 * @return g[N(萔)
	 * @throws BasicLanguageException ɔs\ȗO
	 */
	protected Token restoreVariable(Token token) throws BasicLanguageException {
		Token bracket = line.getNextValidToken();
		int[] subscripts = null;

		if(bracket != null && "(".equals(bracket.toString())) {
			// ϐ̌낪JbȐꍇCzϐƂĎ擾
			line.rewind();
			subscripts = Expression.getSubscripts(env, ctx, line);
		} else if(bracket != null) {
			// JbRȊÔ̂ǂł܂ꍇ̓|C^߂
			line.rewind();
		}
		Variable var = env.variableTable.getVariable(ctx, token, subscripts);

		// ϐ̓e萔ɕϊĕԂ
		return var.toToken();
	}
	/**
	 * KꂽZq̖̂ԂD
	 * @param token 
	 * @param alone true:PZq / false:񍀉Zq
	 * @return
	 */
	protected String getOperatorName(Token token, boolean alone) {
		String opname = token.getStrValue();
		if(token.getType() == Token.TYPE_RESERVED_WORD && token.getFuncType() != Token.RTYPE_OPR) {
			// \łZqłȂꍇ͊֐
			return SyntaxConstant.S_OPR_FNC;
		}

		// PZqłȂꍇ͕ϊsv
		if(alone == false) {
			return opname;
		}

		if(SyntaxConstant.S_OPR_PLS.equals(opname)) {
			// vX
			opname = SyntaxConstant.S_OPR_PSN;
		} else if(SyntaxConstant.S_OPR_MNS.equals(opname)) {
			// }CiX
			opname = SyntaxConstant.S_OPR_MSN;
		}

		return opname;
	}
	/**
	 * ZqX^bNђlX^bN̓efobOOC^[֏o͂D
	 */
	private void debugOutStack() {
		BasicRuntimeConfig config = env.config;
		if(config == null || config.debug == false) {
			return;
		}

		StringBuffer sb = new StringBuffer();
		// ZqX^bN
		sb.append("[");
		boolean first = true;
		for(Iterator it = operatorStack.iterator(); it.hasNext();) {
			Operator op = (Operator)it.next();
			sb.append(first == false ? ", " : "");
			sb.append(op.operator);
			first = false;
		}
		sb.append("]");
		first = true;
		// lX^bN
		sb.append("(");
		for(Iterator it = valueStack.iterator(); it.hasNext();) {
			Token token = (Token)it.next();
			sb.append(first == false ? ", " : "");
			sb.append(token.getStrValue());
			first = false;
		}
		sb.append(")");

		config.log.println("Stack: " + sb.toString());
	}
	/**
	 * ZqD
	 * D揇ʂƃLN^i[\ȃIuWFNgD
	 * ̕]ɂ̂ݎgpD
	 * @author satoshi akabane@logical-paradox.org
	 * @version $Revision: 1.26 $
	 */
	class Operator {
		/** Zq */
		protected final String operator;
		/** ֐ */
		protected final String funcname;
		/** ֐^ */
		protected final int functype;
		/** D揇 */
		protected final int priority;

		/**
		 * RXgN^D
		 * @param token g[N
		 * @param prio D揇
		 */
		protected Operator(Token token, int prio) {
			String opname = token.getStrValue();
			if(token.getType() == Token.TYPE_RESERVED_WORD) {
				// \̏ꍇ́CύX
				operator = SyntaxConstant.S_OPR_FNC;
				funcname = token.getStrValue();
				functype = token.getFuncType();
			} else {
				operator = opname;
				funcname = null;
				functype = -1;
			}
			priority = prio;
		}
		/**
		 * ֐ǂԂD
		 * @return true:֐ / false:Zq
		 */
		protected boolean isFunction() {
			return funcname != null && functype != Token.RTYPE_OPR;
		}
		/**
		 * _ZqǂԂD
		 * @return true:_Zq / false:ȊO
		 */
		protected boolean isLogicalOperator() {
			return funcname != null && functype == Token.RTYPE_OPR;
		}
		/**
		 * PZqǂԂD
		 * @return true:PZq / false:񍀉Zq
		 */
		protected boolean needOnlySingleOperand() {
			return
					SyntaxConstant.S_OPR_MSN.equals(operator) ||	// }CiX
					SyntaxConstant.S_OPR_PSN.equals(operator) ||	// vX
					SyntaxConstant.S_LOPR_NOT.equals(funcname);		// NOTZq
		}
	}
	/**
	 * ֐Ă邩ǂԂD
	 * @return true:֐ / false:ʏ̎]
	 */
	public boolean isEvaluatingFunction() {
		return funcproc;
	}
	/**
	 * zϐ̓Y͂D
	 * ͈ʒu݂͌̎s|C^ł('('̈ʒuw肷邱)
	 * @param env BASIC^C
	 * @param ctx BASIC^CReLXg
	 * @param line BASICR}hs
	 * @return YXg
	 * @throws BasicLanguageException ^ϊG[Ȃ
	 */
	public static final int[] getSubscripts(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		Expression expr = new Expression(env, ctx, line, true);
		List subscripts = new ArrayList();
		Token token = null;
		
		while(expr.isTerminated() == false) {
			token = expr.eval();
			if(token != null) {
				subscripts.add(token);
			}
		}
		
		// Ỷ
		int[] res = new int[subscripts.size()];
		int cnt = 0;

		if(res.length == 0) {
			// YwȂ̏ꍇSyntax error
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
		}
		for(Iterator it = subscripts.iterator(); it.hasNext();) {
			token = (Token)it.next();
			int value = OperationUtils.intValue(token, ctx);
			res[cnt++] = value;
		}

		return res;
	}
	/**
	 * ̕]ɑ邩ǂԂD
	 * ֐łȂꍇ͏trueԋpD
	 * @return true:  / false: ɏI
	 */
	public boolean isTerminated() {
		return funcproc == false || remain == false;
	}
	/**
	 * ֐̏ꍇɁC݂̎邩ǂԂD
	 * @return true:  / false: ֐͏I
	 */
	public boolean hasNextToken() {
		return remain;
	}
	/**
	 * BASICR}hsԂ.
	 * @return BASICR}hs
	 */
	public BasicCommandLine getBasicCommandLine() {
		return line;
	}
	/**
	 * ]̎OD
	 * ֐[hŉғꍇC擪'('XLbvD<br>
	 * tɐ擪'('łȂ΁C\G[ƂȂD
	 * @throws BasicLanguageException \G[
	 */
	protected void preEvaluation() throws BasicLanguageException {
		// ]pX^bNђlX^bNCʃlXgx̏
		init();
		evalCount++;
		if(funcproc == true && evalCount == 1) {
			Token token = null;
			do {
				// white space̓XLbv
				token = line.getNextToken();
			} while(token != null && token.getType() == Token.TYPE_CHARACTER && " ".equals(token.getStrValue()));

			if(
				token == null ||
				token.getType() != Token.TYPE_BRACKET ||
				!("" + SyntaxConstant.C_BRACKET_LEFT).equals(token.getStrValue())
			) {
				throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
			}
			// ʂ̃lXgx͕ύXȂƂƂɂ
		}
	}
}
