/*
 * $Id: Real.java,v 1.7 2007/03/19 17:18:58 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.runtime.mathpack;

/**
 * ̓`D
 * w{̌`Ŏlێ\́D
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.7 $
 */
public class Real {
	/** x - Px */
	public static final int PRECISION_SINGLE = 1;
	/** x - {x */
	public static final int PRECISION_DOUBLE = 2;

	/*
	 * ȉ̃tB[h́CNumberParsergp̂
	 * protectedɂĂƁD
	 */
	/** (true: / false:) */
	protected boolean positive = false;
	/** x */
	protected final int precision;
	/** w */
	protected int exponent;
	/**  */
	protected int[] fraction;
	/** ̌ */
	protected int fractionOccupied = 0;

	/** `̕ */
	private String normalForm;
	/** K\L̕ */
	private String exprForm;

	/**
	 * ̌ݒ肷D
	 * @param occ (l)
	 */
	protected void setFractionOccupied(int occ) {
		while(occ > 1 && fraction[occ-1] == 0) {
			occ--;
		}
		fractionOccupied = occ;
	}
	/**
	 * ̎̕\ԂD
	 * \̓LbV邽߁Cȍ~̓LbVԋpD
	 * @param expr true:K\L / false:`
	 * @return \
	 */
	public String toString(boolean expr) {
		return expr == true ? toExprString() : toString();
	}
	/**
	 * ̎̕\ԂD
	 * \̓LbV邽߁Cȍ~̓LbVԋpD
	 * @return \
	 */
	public String toString() {
		if(normalForm != null) {
			return normalForm;
		}
		StringBuffer sb = new StringBuffer();
		for(int i = 0; i < fractionOccupied; i++) {
			sb.append("" + fraction[i]);
		}
		if(exponent >= 0) {
			// ̐̏ꍇ
			if(exponent >= fractionOccupied-1) {
				int loop = exponent - (fractionOccupied-1);
				for(int i = 0; i < loop; i++) {
					sb.append("0");
				}
			} else {
				sb.insert(exponent+1, '.');
			}
		} else if(fraction[0] > 0) {
			// ̐̏ꍇ
			sb.insert(0, "0.");
			int loop = (-exponent)-1;
			for(int i = 0; i < loop; i++) {
				sb.insert(2, '0');
			}
		}
		String value = sb.length() == 0 ? "0" : sb.toString();
		// ŁCl0łȂꍇ̂݃}CiXǉ
		normalForm = positive == false && !"0".equals(value) ? "-" + value : value;
		return normalForm;
	}
	/**
	 * ̎̕\𐳋K\LŕԂD
	 * \̓LbV邽߁Cȍ~̓LbVԋpD
	 * @return \
	 */
	public String toExprString() {
		if(exprForm != null) {
			return exprForm;
		}
		StringBuffer sb = new StringBuffer();
		sb.append(positive == false ? "-" : "");
		sb.append("" + fraction[0]);
		sb.append(fractionOccupied > 1 ? "." : "");
		for(int i = 1; i < fractionOccupied; i++) {
			sb.append("" + fraction[i]);
		}
		if(fractionOccupied > 0) {
			sb.append("E");
			sb.append(exponent < 0 ? "" : "+");
			sb.append(exponent);
		}
		exprForm = sb.toString(); 
		return exprForm;
	}
	/**
	 * RXgN^D
	 * @param prec x
	 * @param figures ̌
	 * @param value l(`)
	 * @see Real#PRECISION_SINGLE
	 * @see Real#PRECISION_DOUBLE
	 */
	public Real(int prec, int figures, String value) {
		precision = prec;
		fraction = new int[figures];
		parser(value);
	}
	/**
	 * RXgN^D
	 * @param figures ̌
	 * @param value l
	 */
	public Real(int figures, float value) {
		precision = PRECISION_SINGLE;
		fraction = new int[figures];
		parser(Float.toString(value));
	}
	/**
	 * RXgN^D
	 * @param figures ̌
	 * @param value l
	 */
	public Real(int figures, double value) {
		precision = PRECISION_DOUBLE;
		fraction = new int[figures];
		parser(Double.toString(value));
	}
	/**
	 * RXgN^D
	 * Rs[RXgN^Ƃē삷D
	 * @param real l
	 */
	public Real(Real real) {
		precision = real.precision;
		exponent = real.exponent;
		fractionOccupied = real.fractionOccupied;
		positive = real.positive;
		int figures = real.fraction.length;
		fraction = new int[figures];
		System.arraycopy(real.fraction, 0, fraction, 0, figures);
	}
	/**
	 * ԂD
	 * @return true: / false:
	 */
	public boolean isPositive() {
		return positive;
	}
	/**
	 * ݒ肷D
	 * Iɂ͕̃LbV
	 * @param b true: / false:
	 */
	public void setPositive(boolean b) {
		positive = b;
		normalForm = exprForm = null;
	}
	/**
	 * ̐xԂD
	 * @return x
	 * @see #PRECISION_SINGLE
	 * @see #PRECISION_DOUBLE
	 */
	public int getPrecision() {
		return precision;
	}
	/**
	 * ǂԂD
	 * @return true: / false:
	 */
	public boolean isEven() {
		if(fractionOccupied == 0) {
			return true;
		}
		String str = toString();
		int num = Integer.parseInt("" + str.charAt(str.length() -1));
		
		return num % 2 == 0;
	}
	/**
	 * el[ǂԂD
	 * @return true:[ / false:[ȊO
	 */
	public boolean isZero() {
		for(int i = 0; i < fraction.length; i++) {
			if(fraction[i] > 0) {
				return false;
			}
		}
		return true;
	}
	/**
	 * `̎͂D
	 * ̌`ƂẮCȉ̂̂󂯓F
	 * <li>123.456</li>
	 * <li>+0.123</li>
	 * <li>-.123</li>
	 * <li>55.99000</li>
	 * <li>104.22e+5</li>
	 * <li>4.21e-14</li>
	 * @param value `̎
	 */
	protected void parser(String value) {
		NumberParser parser = new NumberParser(this, value);
		parser.parse();
	}
}
