/*
 * $Id: SquareWaveGenerator.java,v 1.1 2008/02/06 16:17:33 akabane Exp $
 */
package org.logical_paradox.petitbasic.sound;

/**
 * `gWFl[^.
 * @author satoshi akabane@logical-paradox.org
 * @version $revision$
 */
public class SquareWaveGenerator extends WaveGenerator {
	/**
	 * RXgN^.
	 * @param freq TvOg
	 */
	public SquareWaveGenerator(long freq) {
		super(freq);
	}
	/**
	 * TvOf[^𐶐B
	 * @return ꂽg`f[^(1)
	 */
	protected byte[] generateWaveData() {
		byte[] f = new byte[(int)(samplingFreqRate / frequency)];
		for(int i = 0; i < f.length / 2; i++) {
			f[i] = (byte)volume;
			f[i+f.length/2] = (byte)-volume;
		}
		if(f.length % 2 != 0) {
			f[f.length-1] = f[f.length-2];
		}
		return f;
	}
}
