/*
 * BDF2BDB - BDF font data conveter
 * Release version 0.0.0
 * Copyright (c)2006 satoshi akabane
 * http://www.logical-paradox.org/
 *
 * The MIT License
 * Copyright (c) 2006 satoshi akabane(akabane@logical-paradox.org)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights 
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#include "bdf2bdb.h"
#include "mappings.h"
#include "apcommon.h"

static char linebuf[1024];


/*
 * get and return a error message mapping with error code.
 * in:
 *		error_code - error code.
 * out:
 * 		pointer of an error message text.
 */
const char *get_error_msg(int error_code)
{
	static const char *unmapped_error_msg = "unmapped error [%d]";

	if(error_code < 0 || gs_number_of_error_msgs >= error_code) {
		sprintf(linebuf, unmapped_error_msg, error_code);
		return (const char *)linebuf;
	} else {
		return gs_error_msg_tbl[error_code];
	}
}


/*
 * output bdf2bdb log.
 * in:
 *		log_level - log level
 *		msgptr - message
 *		lineno - line number.
 * out:
 *		nothing.
 */
void log(int log_level, const char *msgptr, int lineno)
{
	static const char *log_level_msg[] = {"ERROR", "WARNING", "INFO", "DEBUG"};

	if(log_level < 0 || log_level >= sizeof(log_level_msg) / sizeof(char *)) {
		log_level = 0;
	}

	/* format and display log message */
	printf("[%s] %s", log_level_msg[log_level], msgptr);
	if(lineno >= 0) {
		printf(" in line %d.", lineno);
	}
	printf("\n");
}
