/*
 * BDF2BDB - BDF font data conveter
 * Release version 0.0.0
 * Copyright (c)2006 satoshi akabane
 * http://www.logical-paradox.org/
 *
 * The MIT License
 * Copyright (c) 2006 satoshi akabane(akabane@logical-paradox.org)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights 
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "common.h"

/*
 * read a line from buffer.
 * in:
 *		*ptr - data source ptr.
 *		len - max length for read.
 *		*buf - read buffer ptr.
 * out:
 *		next ptr.
 */
char *readline(char *ptr, int len, char *buf)
{
	int exitc = 0;
	while(len > 0 && exitc == 0) {
		*buf = *ptr;
		if(*buf == '\n') {
			exitc = 1;
		} else if(*buf == '\0') {
			exitc = 2;
		}
		buf++;
		ptr++;
		len--;
	}
	*buf = '\0';

	return exitc == 2 ? NULL : ptr;
}
/*
 * get file byte size.
 * in:
 *		FILE *fp - file handle.
 * out:
 *		file byte size.
 */
int get_filesize(FILE *fp)
{
	int filesize = 0;

	fseek(fp, 0, SEEK_END);
	filesize = ftell(fp);
	fseek(fp, 0, SEEK_SET);

	return filesize;
}

/*
 * 32-bit integer value to byte array.
 * integer is stored in an array ordered by big-endian.
 * in:
 *		value - integer value(32-bit)
 *		bytes - storage
 * out:
 *		nothing.
 */
void int32_to_bytes(int value, char *bytes)
{
	char b1, b2, b3, b4;

	b4 = (char)((value & 0x000000ff));
	b3 = (char)((value & 0x0000ff00) >>  8);
	b2 = (char)((value & 0x00ff0000) >> 16);
	b1 = (char)((value & 0xff000000) >> 24);

	*(bytes+0) = b1;
	*(bytes+1) = b2;
	*(bytes+2) = b3;
	*(bytes+3) = b4;
}


/*
 * 16-bit integer value to byte array.
 * integer is stored in an array ordered by big-endian.
 * in:
 *		value - integer value(32-bit)
 *		bytes - storage
 * out:
 *		nothing.
 */
void int16_to_bytes(int value, char *bytes)
{
	char b1, b2;

	value &= 0xffff;
	b2 = (char)((value & 0x000000ff));
	b1 = (char)((value & 0x0000ff00) >>  8);

	*(bytes+0) = b1;
	*(bytes+1) = b2;
}


/*
 * byte array to 32-bit integer value.
 * integer is stored in an array ordered by big-endian.
 * in:
 *		bytes - byte array of integer value(4 bytes).
 * out:
 *		integer value
 */
int bytes_to_int32(char *bytes)
{
	int value = 0;
	char b1, b2, b3, b4;

	b1 = *(bytes+0);
	b2 = *(bytes+1);
	b3 = *(bytes+2);
	b4 = *(bytes+3);

	value |= (int)b4 & 0xff;
	value |= ((int)b3 & 0xff) <<  8;
	value |= ((int)b2 & 0xff) << 16;
	value |= ((int)b1 & 0xff) << 24;

	return value;
}


/*
 * hex string to 32-bit integer value.
 * in:
 *		str - pointer of hex string.
 * out:
 *		integer value
 */
int hex_to_int32(char *str)
{
	int value = 0;
	int first = 1;
	char c;

	while(*str != '\0') {
		if(first == 0) {
			value <<= 4;
		}
		c = tolower(*str);
		value |= isdigit(c) ? (int)c - '0' : (int)c - ('a'-10);
		str++;
		first = 0;
	}

	return value;
}
