#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "common.h"
#include "procedures.h"

#define TEST_NG		0
#define TEST_OK		(!0)


/*
 * test for readline.
 */
int test_readline()
{
	char *ptr = "this is sample for readline.\r\nAAABBBCCC\r\nTESTTESTTESTING";
	char *nextptr = ptr;
	char *buf = (char *)malloc(2048);
	int exitc = TEST_OK;

	printf("[readline] testing .... ");

	// line.1
	nextptr = readline(nextptr, 2048, buf);
	if(nextptr == NULL || strncmp("this is sample for readline.\r\n", buf, strlen("this is sample for readline.\r\n")) != 0) {
		printf("assertion error in case.1 ", buf);
		exitc = TEST_NG;
		goto finally;
	}

	// line.2
	nextptr = readline(nextptr, 2048, buf);
	if(nextptr == NULL || strncmp("AAABBBCCC\r\n", buf, strlen("AAABBBCCC\r\n")) != 0) {
		printf("assertion error in case.2 ");
		exitc = TEST_NG;
		goto finally;
	}

	// line.3(end of lines)
	nextptr = readline(nextptr, 2048, buf);
	if(nextptr != NULL || strncmp("TESTTESTTESTING", buf, strlen("TESTTESTTESTING")) != 0) {
		printf("assertion error in case.3 ");
		exitc = TEST_NG;
		goto finally;
	}

finally:
	free(buf);

	return exitc;
}

/*
 * test for get_filesize.
 */
int test_get_filename()
{
	FILE *fp;
	int filesize;

	printf("[get_filesize] testing .... ");
	if((fp = fopen("test" PATH_SYM "testfile_for_get_filesize", "r")) == NULL) {
		return TEST_NG;
	}

	/* get_filesize() */
	filesize = get_filesize(fp);
	fclose(fp);

	return filesize == 5868 ? TEST_OK : TEST_NG;
}


/*
 * test for int32_to_bytes.
 */
int test_int32_to_bytes_8bit()
{
	char buf[4] = {0x00, 0x00, 0x00, 0x00};
	printf("[int32_to_bytes_8bit] testing .... ");

	int32_to_bytes(0xf7, buf);

	printf("%02x %02x %02x %02x  ", (int)buf[0] & 0xff, (int)buf[1] & 0xff, (int)buf[2] & 0xff, (int)buf[3] & 0xff);
	if(buf[0] == 0 && buf[1] == 0 && buf[2] == 0 && buf[3] == (char)0xf7) {
		return TEST_OK;
	} else {
		return TEST_NG;
	}
}


/*
 * test for int32_to_bytes.
 */
int test_int32_to_bytes_16bit()
{
	char buf[4] = {0x00, 0x00, 0x00, 0x00};
	printf("[int32_to_bytes_16bit] testing .... ");

	int32_to_bytes(0xf799, buf);

	printf("%02x %02x %02x %02x  ", (int)buf[0] & 0xff, (int)buf[1] & 0xff, (int)buf[2] & 0xff, (int)buf[3] & 0xff);
	if(buf[0] == 0 && buf[1] == 0 && buf[2] == (char)0xf7 && buf[3] == (char)0x99) {
		return TEST_OK;
	} else {
		return TEST_NG;
	}
}


/*
 * test for int32_to_bytes.
 */
int test_int32_to_bytes_32bit()
{
	char buf[4] = {0x00, 0x00, 0x00, 0x00};
	printf("[int32_to_bytes_32bit] testing .... ");

	int32_to_bytes(0x8ef8f799, buf);

	printf("%02x %02x %02x %02x  ", (int)buf[0] & 0xff, (int)buf[1] & 0xff, (int)buf[2] & 0xff, (int)buf[3] & 0xff);
	if(buf[0] == (char)0x8e && buf[1] == (char)0xf8 && buf[2] == (char)0xf7 && buf[3] == (char)0x99) {
		return TEST_OK;
	} else {
		return TEST_NG;
	}
}


/*
 * test for bytes_to_int32.
 */
int test_bytes_to_int32_8bit()
{
	char buf[4] = {0x00, 0x00, 0x00, 0xf8};
	int value;

	printf("[bytes_to_int32_8bit] testing .... ");

	value = bytes_to_int32(buf);
	return value == 0xf8 ? TEST_OK : TEST_NG;
}


/*
 * test for bytes_to_int32.
 */
int test_bytes_to_int32_16bit()
{
	char buf[4] = {0x00, 0x00, 0x89, 0xf8};
	int value;

	printf("[bytes_to_int32_16bit] testing .... ");

	value = bytes_to_int32(buf);
	return value == 0x89f8 ? TEST_OK : TEST_NG;
}


/*
 * test for bytes_to_int32.
 */
int test_bytes_to_int32_32bit()
{
	char buf[4] = {0xff, 0x99, 0x89, 0xf8};
	int value;

	printf("[bytes_to_int32_32bit] testing .... ");

	value = bytes_to_int32(buf);
	return value == 0xff9989f8 ? TEST_OK : TEST_NG;
}


/*
 * test for hex_to_int32.
 */
int test_hex_to_int32_8bit()
{
	int value = 0;

	printf("[hex_to_int32_8bit] testing .... ");

	value = hex_to_int32("fa");
	printf(" %04x  ", value);

	return value == 0xfa ? TEST_OK : TEST_NG;
}


/*
 * test for hex_to_int32.
 */
int test_hex_to_int32_16bit()
{
	int value = 0;

	printf("[hex_to_int32_16bit] testing .... ");

	value = hex_to_int32("fa99");
	printf(" %04x  ", value);

	return value == 0xfa99 ? TEST_OK : TEST_NG;
}


/*
 * test for hex_to_int32.
 */
int test_hex_to_int32_32bit()
{
	int value = 0;

	printf("[hex_to_int32_32bit] testing .... ");

	value = hex_to_int32("fa998001");
	printf(" %04x  ", value);

	return value == 0xfa998001 ? TEST_OK : TEST_NG;
}


/*
 * test for p_startfont.
 */
int test_p_startfont_ok()
{
	int error_code = -1;
	char* tokens[] = {"START", "2.1"};
	BDB bdb;

	printf("[p_startfont_ok] testing .... ");
	error_code = p_startfont(2, tokens, &bdb);

	return
			error_code == ERR_NO_ERROR &&
			bdb.major_version == '2' &&
			bdb.minor_version == '1'
		? TEST_OK : TEST_NG;
}


/*
 * test for p_startfont.
 */
int test_p_startfont_params()
{
	int error_code = -1;
	char* tokens[] = {"START", "2.1", "999"};
	BDB bdb;

	printf("[p_startfont_params] testing .... ");
	error_code = p_startfont(3, tokens, &bdb);

	return error_code == ERR_SYNTAX_ERROR ? TEST_OK : TEST_NG;
}


/*
 * test for p_startfont.
 */
int test_p_startfont_version()
{
	int error_code = -1;
	char* tokens[] = {"START", "1.0"};
	BDB bdb;

	printf("[p_startfont_version] testing .... ");
	error_code = p_startfont(2, tokens, &bdb);

	return error_code == ERR_UNSUPPORTED_VERSION ? TEST_OK : TEST_NG;
}


/*
 * test for p_chars.
 */
int test_p_chars_ok()
{
	int error_code = -1;
	char* tokens[] = {"CHARS", "255"};
	BDB bdb;

	printf("[p_chars_ok] testing .... ");
	error_code = p_chars(2, tokens, &bdb);

	return
			error_code == ERR_NO_ERROR &&
			bdb.chars[0] == 0x00 && bdb.chars[1] == 0x00 && bdb.chars[2] == 0x00 && bdb.chars[3] == -1
			? TEST_OK : TEST_NG;
}


/*
 * test for p_chars.
 */
int test_p_chars_ng()
{
	int error_code = -1;
	char* tokens[] = {"CHARS", "255", "32767"};
	BDB bdb;

	printf("[p_chars_ng] testing .... ");
	error_code = p_chars(3, tokens, &bdb);

	return error_code == ERR_SYNTAX_ERROR ? TEST_OK : TEST_NG;
}


/*
 * test for p_startchar.
 */
int test_p_startchar_ok()
{
	int error_code = -1;
	char* tokens[] = {"STARTCHAR", "A"};
	BDB bdb;
	FONT font;

	printf("[p_startchar_ok] testing .... ");
	bdb.font = &font;
	bdb.font_count = 0;

	error_code = p_startchar(2, tokens, &bdb);

	/* debug information out */
	printf("count = %d, start_char = %02x %02x %02x %02x  "
				, bdb.font_count
				, (int)font.start_char[0] & 0xff
				, (int)font.start_char[1] & 0xff
				, (int)font.start_char[2] & 0xff
				, (int)font.start_char[3] & 0xff
		);

	return
			error_code == ERR_NO_ERROR &&
			bdb.font_count == 0 &&
			font.start_char[0] == 0x00 &&
			font.start_char[1] == 0x00 &&
			font.start_char[2] == 0x00 &&
			font.start_char[3] == 0x41
		? TEST_OK : TEST_NG;
}


/*
 * test for p_startchar.
 */
int test_p_startchar_no_chars()
{
	int error_code = -1;
	char* tokens[] = {"STARTCHAR", "A"};
	BDB bdb;

	printf("[p_startchar_no_chars] testing .... ");
	bdb.font = NULL;

	error_code = p_startchar(2, tokens, &bdb);

	return error_code == ERR_ILLEGAL_FONT_STATE ? TEST_OK : TEST_NG;
}


/*
 * test for p_encoding.
 */
int test_p_encoding_ok()
{
	int error_code = -1;
	char* tokens[] = {"ENCODING", "1024"};
	BDB bdb;
	FONT font;

	printf("[p_encoding_ok] testing .... ");
	bdb.font = &font;
	bdb.font_count = 0;

	error_code = p_encoding(2, tokens, &bdb);

	/* debug information out */
	printf("count = %d, encoding = %02x %02x %02x %02x  "
				, bdb.font_count
				, (int)font.encoding[0] & 0xff
				, (int)font.encoding[1] & 0xff
				, (int)font.encoding[2] & 0xff
				, (int)font.encoding[3] & 0xff
		);

	return
			error_code == ERR_NO_ERROR &&
			bdb.font_count == 0 &&
			font.encoding[0] == 0x00 &&
			font.encoding[1] == 0x00 &&
			font.encoding[2] == 0x04 &&
			font.encoding[3] == 0x00
		? TEST_OK : TEST_NG;
}


/*
 * test for p_encoding.
 */
int test_p_encoding_ng()
{
	int error_code = -1;
	char* tokens[] = {"ENCODING", "255", "32767"};
	BDB bdb;

	printf("[p_encoding_ng] testing .... ");
	error_code = p_encoding(3, tokens, &bdb);

	return error_code == ERR_SYNTAX_ERROR ? TEST_OK : TEST_NG;
}


/*
 * test for p_encoding.
 */
int test_p_encoding_no_chars()
{
	int error_code = -1;
	char* tokens[] = {"ENCODING", "1024"};
	BDB bdb;

	printf("[p_encoding_no_chars] testing .... ");
	bdb.font = NULL;

	error_code = p_encoding(2, tokens, &bdb);

	return error_code == ERR_ILLEGAL_FONT_STATE ? TEST_OK : TEST_NG;
}


/*
 * test driver.
 */
int main(int argc, char **argv)
{
	int (*testcases[])() = {
			test_get_filename,
			test_readline,
			test_int32_to_bytes_8bit,
			test_int32_to_bytes_16bit,
			test_int32_to_bytes_32bit,
			test_bytes_to_int32_8bit,
			test_bytes_to_int32_16bit,
			test_bytes_to_int32_32bit,
			test_hex_to_int32_8bit,
			test_hex_to_int32_16bit,
			test_hex_to_int32_32bit,
			test_p_startfont_ok,
			test_p_startfont_params,
			test_p_startfont_version,
			test_p_chars_ok,
			test_p_chars_ng,
			test_p_startchar_ok,
			test_p_startchar_no_chars,
			test_p_encoding_ok,
			test_p_encoding_ng,
			test_p_encoding_no_chars
		};
	int total_result = TEST_OK;
	int i;

	/* print copyright. */
	printf("bdf2bdb unit test driver  Copyright (c)2006 satoshi akabane\n\n");

	/* run execute test cases */
	for(i = 0; i < sizeof(testcases) / sizeof(testcases[0]); i++) {
		int rc = (*testcases[i])();
		if(rc == TEST_OK) {
			printf("OK\n");
		} else {
			printf("NG\n");
			total_result = TEST_NG;
		}
	}

	printf("\n");
	if(total_result == TEST_OK) {
		printf("success.\n");
	} else {
		printf("one or more tests failed.");
	}
}