/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: PetitBasicApplet.java,v 1.34 2008/12/07 15:36:38 akabane Exp $
 */
package org.logical_paradox.petitbasic.gui;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import javax.sound.sampled.LineUnavailableException;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JPanel;

import netscape.javascript.JSObject;

import org.logical_paradox.common.util.PropertyUtils;
import org.logical_paradox.petitbasic.BuiltinCommandLibrary;
import org.logical_paradox.petitbasic.PetitBasic;
import org.logical_paradox.petitbasic.gui.bios.CookieFileSystem;
import org.logical_paradox.petitbasic.gui.bios.FontDriver;
import org.logical_paradox.petitbasic.gui.bios.StandardOutput;
import org.logical_paradox.petitbasic.gui.bios.music.MusicDriver;
import org.logical_paradox.petitbasic.gui.hardware.Display;
import org.logical_paradox.petitbasic.gui.hardware.GraphicVRAM;
import org.logical_paradox.petitbasic.gui.hardware.HardwareTimer;
import org.logical_paradox.petitbasic.gui.hardware.InterruptController;
import org.logical_paradox.petitbasic.gui.hardware.KeyInputDevice;
import org.logical_paradox.petitbasic.gui.hardware.MouseDevice;
import org.logical_paradox.petitbasic.gui.hardware.PSCI;
import org.logical_paradox.petitbasic.gui.hardware.Sound;
import org.logical_paradox.petitbasic.gui.hardware.SpriteEngine;
import org.logical_paradox.petitbasic.gui.hardware.TextVRAM;
import org.logical_paradox.petitbasic.gui.hardware.VDP;
import org.logical_paradox.petitbasic.gui.hardware.VSYNC;
import org.logical_paradox.petitbasic.runtime.BasicRuntime;

/**
 * v`BASICAvbgD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.34 $
 */
public class PetitBasicApplet extends JApplet {
	/** suid */
	private static final long serialVersionUID = -7084052188818938094L;
	/** AvbgƂċNꂽǂ */
	private boolean runAsApplet = true;
	/** GUIRtBO */
	private PetitBasicGuiConfig config;
	/** XvCgGW */
	private SpriteEngine spEngine;
	/** OtBbNVRAM */
	private GraphicVRAM gvram;
	/** eLXgVRAM */
	private TextVRAM tvram;
	/** ^C */
	private PetitBasicGuiRuntimeEnv runtime;
	/** zfBXvC */
	private Display display;

	/**
	 * Avbg̏R[hD
	 */
	public void init() {
		super.init();
		Container container = null;

		// RtBO[V̍쐬
		Properties property = PropertyUtils.getProperties("petitbasic_gui.properties");
		config = new PetitBasicGuiConfig(property);

		try {
			if(runAsApplet == true) {
				// AvbgƂē삵Ăꍇ
				container = getContentPane();
				initApplication(container);
				// Avbgɑ΂ăL[Xi[o^
				addKeyListener(runtime.keyInputDevice);
				// Avbgœ삵ĂꍇCtH[JX擾
				addComponentListener(new ComponentAdapter() {
						public void componentShown(ComponentEvent e) { 
							requestFocus(); 
						} 
					});
			} else {
				// X^hA[AvP[VƂē삵Ăꍇ
				JFrame mainFrm = new JFrame();
				mainFrm.setTitle("petit-basic");
				container = mainFrm.getContentPane();
				initApplication(container);
				// gbvt[ɑ΂ăL[Xi[o^
				mainFrm.addKeyListener(runtime.keyInputDevice);
	
				// EBhE̕\ʒuƃTCY̒
				int width = config.getWindowWidth();
				int height = config.getWindowHeight();
				Dimension windowLocation = Toolkit.getDefaultToolkit().getScreenSize();
				mainFrm.setLocation(((int)windowLocation.getWidth() - width) /2, ((int)windowLocation.getHeight() - height) /2);
				mainFrm.setSize(new Dimension(width +8, height +30));
				mainFrm.setVisible(true);
				mainFrm.setResizable(false);

				runtime.rootFrame = mainFrm;

				mainFrm.addWindowListener(new WindowAdapter() {
						public void windowClosing(WindowEvent e) {
							// tXN[\
							display.setFullScreen(false);
							System.exit(0);
						}
					}
				);
			}
		} catch(IOException e) {
			// Ɏs
			e.printStackTrace();
		}
	}
	/**
	 * x[XReiɁCGUIR|[lgzuĉʂ쐬D
	 * @param baseContainer x[XRei
	 * @throws IOException 
	 */
	public void initApplication(Container baseContainer) throws IOException {
		InputStream in = getClass().getResourceAsStream(config.getFontFilename());
		if(in == null) {
			throw new IOException("font file [" + config.getFontFilename() + "] is not found in classpath.");
		}
		FontDriver fd = FontDriver.load(in);

		runtime = new PetitBasicGuiRuntimeEnv(config);

		// J[\_ŊJn
		runtime.cursor = new Cursor(runtime);

		tvram = new TextVRAM(80, 30, 2, config, fd, runtime.cursor);

		// L[̓foCX̍쐬
		runtime.keyInputDevice = new KeyInputDevice(runtime);

		// Wo͂쐬
		runtime.stdout = new StandardOutput(tvram, runtime);

		JPanel compo = new JPanel() {
			/** svuid */
			private static final long serialVersionUID = 1L;
			public void paint(Graphics g) {
				runtime.display.paint(g, config);
//				runtime.cursor.show(g);
			}
		};
		baseContainer.setLayout(new BorderLayout());
		baseContainer.add(compo, BorderLayout.CENTER);
		baseContainer.validate();

		gvram = new GraphicVRAM(config.getWindowWidth(), config.getWindowHeight(), 1);

		display = new Display(compo, config.getWindowWidth(), config.getWindowHeight());
		spEngine = new SpriteEngine(1, config);

		// OtBbNVRAMzʂɃoCh
		display.add(gvram);
		display.add(tvram);
		display.add(spEngine);
		
		runtime.display = display;

		try {
			runtime.psg = new Sound(config);
			runtime.md = new MusicDriver(runtime.psg, 10);
		} catch (LineUnavailableException e) {
			e.printStackTrace();
			throw new IOException(e);
		}
		runtime.vdp = new VDP(gvram, spEngine, config);

		// BASICC^v^̍쐬
		BasicRuntime interpreter = new BasicRuntime(new String[]{}, null/*new LoggingPrintStream(System.out)*/);
		runtime.runtime = interpreter;
		interpreter.setBasicRuntimeExtension(new PetitBasicGuiRuntimeExtention(runtime));
		
		if(runAsApplet) {
			// AvbgƂċNĂꍇCt@CVXeCookieFileSystemɕύX
			CookieFileSystem cfs = new CookieFileSystem();
			interpreter.getRuntimeConfig().fileSystem = cfs;
			JSObject win = JSObject.getWindow(this);

			// Cookiet@CVXȅ
			cfs.init(win);
		}

		// f[^z_[Ƀ^Co^
		PetitBasicGuiRuntimeEnvHolder.setEnvironment(runtime);

		// g߂̃[h
		BuiltinCommandLibrary.getInstance().loadCommand("extend_cmds_gui.properties");

		runtime.fontDriver = fd;

		compo.validate();

		// EFJbZ[W\
		String msg =
				"Petit-BASIC version 1.0.1\r\n" +
				"Copyright (c)2006,2007,2008 satoshi akabane(http://www.logical-paradox.org/)\r\n" +
				"This program is distributed under The MIT/X Consortium License.\r\n" +
				Runtime.getRuntime().maxMemory() + "bytes free.\r\n" +
				PetitBasic.OK_PROMPT;

		runtime.stdout.println(msg);

		// n[hEFA荞ݓo^
		InterruptController ic = new InterruptController(3);
		ic.register(0, new VSYNC(runtime), config.getVSYNC());
		ic.register(1, new PSCI(runtime), 1);		// TEhfoCXœ邽߁A0msOK)
		ic.register(2, new HardwareTimer(runtime), config.getHardwareTimer());

		// BASICXN[GfB^̊Jn
		ScreenEditor editor = new ScreenEditor(runtime);
		runtime.stdout.setScrollUpEventListener(editor);
		runtime.screenEditor = editor;


		// }EXfoCX̒ǉ
		MouseDevice mouse = new MouseDevice();
		compo.addMouseListener(mouse);
		compo.addMouseMotionListener(mouse);
		runtime.mouseDevice = mouse;

		editor.start();
	}
	/**
	 * C\bhD
	 * X^hA[ŋNꍇC̃\bhJnD
	 * @param args vO 
	 * @throws Exception ȂO
	 */
	public static final void main(String[] args) throws Exception {
		PetitBasicApplet applet = new PetitBasicApplet();
		applet.runAsApplet = false;
		applet.init();
	}
}
