/*
 * $Id: ScreenEditor.java,v 1.29 2008/11/24 15:54:14 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.gui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;

import org.logical_paradox.petitbasic.PetitBasic;
import org.logical_paradox.petitbasic.gui.bios.ASCIICode;
import org.logical_paradox.petitbasic.gui.bios.FIFO;
import org.logical_paradox.petitbasic.gui.event.ScrollEvent;
import org.logical_paradox.petitbasic.gui.event.ScrollEventListener;
import org.logical_paradox.petitbasic.runtime.BasicErrorMessage;
import org.logical_paradox.petitbasic.runtime.BasicRuntime;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEvent;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEventListener;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * XN[GfB^D
 * L[͂ĎC͂ꂽꍇɉʂXVD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.29 $
 */
public class ScreenEditor extends Thread implements ScrollEventListener, BasicRuntimeEventListener {
	/** ^C */
	private final PetitBasicGuiRuntimeEnv env;
	/** CTRL+STOPꂽǂ */
	public boolean breakFlag = false;

	/**
	 * RXgN^D
	 * @param e ^C
	 */
	public ScreenEditor(PetitBasicGuiRuntimeEnv e) {
		env = e;
		setDaemon(true);
	}
	/**
	 * XbhC
	 */
	public void run() {
		try {
			boolean first = true;
			env.runtime.setRuntimeEventListener(this);

			// J[\`
			show(first);

			while(true) {
				FIFO fifo = env.getKeyInputBuffer();

				// 1s
				String linebuf = input(fifo);

				// 1ss
				int exitcode = 0;
				if(linebuf != null) {
					try {
						env.cursor.hide();
						env.cursor.setStyle(Cursor.CS_OVERWRITE);
						env.insert = false;
						exitcode = env.runtime.execute(env.stdout, linebuf);
						env.stdout.flush();
					} catch (BasicLanguageException e) {
						// G[̂ŃG[bZ[W\
						String errmsg = BasicErrorMessage.getMessage(e.getErrorCode());
						if(e.getLineno() >= 0) {
							// vOsɉ炩̃G[ꍇ́C̍sԍ\
							errmsg += " in " + e.getLineno();
						}
						env.stdout.println(errmsg);
						// BEEP
						env.md.beep();
						exitcode = BasicRuntime.EXITC_EXEC_LINE_OK;
					} finally {
						switch(exitcode) {
							// vOrŒfC"Break"\
							case BasicRuntime.EXITC_EXEC_BREAK:
								StringBuffer buf = new StringBuffer();
								buf.append(PetitBasic.BREAK_PROMPT);
								int brokenLine = env.runtime.getRuntimeEnvironment().getLastBrokenLine();
								if(brokenLine >= 0) {
									buf.append(" in " + brokenLine);
								}
								
								// BEEP𔭉
								env.md.beep();
								env.stdout.println(buf.toString());
								
							// vO̎sC"Ok"\
							case BasicRuntime.EXITC_EXEC_LINE_OK:
								env.stdout.println(PetitBasic.OK_PROMPT);
								// sԍԂIɉ
								env.autoLineNumber = false;
								break;

							case BasicRuntime.EXITC_ENTRY_LINE:
							case BasicRuntime.EXITC_NO_OPERATION:
								if(env.autoLineNumber == true) {
									// _CNg[hɂvO̓o^AsԍԂ
									int lastEntryLine = env.runtime.getRuntimeEnvironment().getLastEntryLine();
									lastEntryLine += env.autoLineNumberStep;

									// sԍ
									char c = env.runtime.getRuntimeEnvironment().getCommandLine(lastEntryLine) == null ? ' ' : '*';
									env.stdout.print("" + lastEntryLine + c);
								}
								break;
						}
						env.cursor.show();
						linebuf = null;
						
						// L[̓obt@̃NA
						env.getKeyInputBuffer().clear();
					}
				}
				first = false;
				breakFlag = false;

				// J[\ĕ`
				show(first);
			}
		} catch(InterruptedException e) {
			// fꂽ
		}
	}
	/**
	 * ENTER܂ł̓͂D
	 * @param fifo s̓obt@
	 * @return ͂ꂽs
	 * @throws InterruptedException FIFOj^Ɋ荞݂
	 */
	public String input(FIFO fifo) throws InterruptedException {
		String linebuf = null;
		boolean loop = true;

		while(loop) {
			StringBuffer sb = new StringBuffer();
			synchronized(fifo) {
				while(fifo.trigger() == false && fifo.hasNext() == false) {
					fifo.wait();
				}
				// J[\\ɂ1s
				env.cursor.hide();
				char before = '\0';
				while(loop && fifo.hasNext()) {
					char c = fifo.dequeue();
					if(before == ASCIICode.CR && c == ASCIICode.LF) {
						// ENTER͂ꂽꍇCs͓es̓obt@֊i[
						Integer currentLineStatus = (Integer)env.lineTerminalTable.get(env.cursorYpos);
						if(PetitBasicGuiRuntimeEnv.LINE_TERM_CONTINUE.equals(currentLineStatus) == false) {
							// _s̓rłȂꍇCsR[h
							env.lineTerminalTable.set(env.cursorYpos, PetitBasicGuiRuntimeEnv.LINE_TERM_END_OF_LINE);
						}
						env.stdout.print(sb.toString());
						sb = new StringBuffer();
						// ͍s̓rENTERꂽꍇCsm肷ۂɑO𕹗p
						linebuf = scanInputLine(PetitBasicGuiRuntimeEnv.LINE_TERM_CONTINUE.equals(currentLineStatus) ? true : false);
						loop = false;
					}
					before = c;
					sb.append(c);
				}
				
				if(env.screenEditor.breakFlag) {
					throw new InterruptedException();
				}
				if(sb.length() > 0) {
					env.stdout.print(sb.toString());
				}
				show(false);
			}
		}
		return linebuf;
	}
	/**
	 * ENTERꂽ_̏Ԃʂ擾āCs̓f[^ƂĕԂD
	 * @return s̓f[^
	 */
	protected String scanInputLine(boolean forward) {
		// ݂̃J[\sʒuɑkăXL
		Stack lineNumberStack = new Stack();
		boolean first = true;
		for(int i = env.cursorYpos; i >= 0; i--) {
			Integer lt = (Integer)env.lineTerminalTable.get(i);
			if(PetitBasicGuiRuntimeEnv.LINE_TERM_NODATA.equals(lt) || (PetitBasicGuiRuntimeEnv.LINE_TERM_END_OF_LINE.equals(lt) && first == false)) {
				break;
			} else if(PetitBasicGuiRuntimeEnv.LINE_TERM_END_OF_LINE.equals(lt)) {
				first = false;
			}
			// ͍sƂĎ荞
			lineNumberStack.push(new Integer(i));
		}

		List forwardLines = new ArrayList();
		int lastline = -1;
		if(forward == true) {
			// O
			for(int i = env.cursorYpos+1; i < env.config.getCharsVerticalMax(); i++) {
				Integer lt = (Integer)env.lineTerminalTable.get(i);
				if(PetitBasicGuiRuntimeEnv.LINE_TERM_NODATA.equals(lt) == false) {
					// ͍sƂĎ荞
					forwardLines.add(new Integer(i));
				}
				if(PetitBasicGuiRuntimeEnv.LINE_TERM_END_OF_LINE.equals(lt)) {
					// _s̏I[荞񂾂̂ŏI
					lastline = i;
					break;
				}
			}
		}

		// C^[~ie[u̓eXLāAs͓e擾
		StringBuffer sb = new StringBuffer();
		while(lineNumberStack.isEmpty() == false) {
			Integer lineno = (Integer)lineNumberStack.pop();
			int[] line = env.stdout.tvram.vpeek(0, lineno.intValue(), env.config.getCharsHorizonMax());
			for(int j = 0; j < line.length; j++) {
				char c = (char)line[j];
				sb.append(c == 0 ? ' ' : c);
			}
		}
		for(Iterator it = forwardLines.iterator(); it.hasNext();) {
			Integer lineno = (Integer)it.next();
			int[] line = env.stdout.tvram.vpeek(0, lineno.intValue(), env.config.getCharsHorizonMax());
			for(int j = 0; j < line.length; j++) {
				char c = (char)line[j];
				sb.append(c == 0 ? ' ' : c);
			}
		}

		if(lastline >= 0) {
			env.cursorYpos = lastline;
		}
		return sb.toString()/*.trim()*/;
	}
	/**
	 * eLXgʂXN[AbvۂɌĂяoCxgnhD
	 * @param Cxg
	 */
	public void scrollUp(ScrollEvent event) {
		// C^[~ie[u̐擪s폜
		env.lineTerminalTable.remove(0);
		if(env.config.functionKeyDisplay == true) {
			// ŉi1̍sɑ΂čsǉ
			env.lineTerminalTable.add(env.lineTerminalTable.size()-1, PetitBasicGuiRuntimeEnv.LINE_TERM_NODATA);
		} else {
			// ŉiɑ΂čsǉ
			env.lineTerminalTable.add(PetitBasicGuiRuntimeEnv.LINE_TERM_NODATA);
		}
	}
	/**
	 * XN[_Eɑ΂CxgnhD
	 * @param event Cxg
	 */
	public void scrollDown(ScrollEvent event) {
		// wsɑ΂āCVsǉ
		Vector ltt = env.lineTerminalTable;
		ltt.insertElementAt(PetitBasicGuiRuntimeEnv.LINE_TERM_END_OF_LINE, event.getY());

		// C^[~ie[u̍ŏIs폜(t@NVL[\̏ꍇ͂̏̍s폜)
		ltt.remove(ltt.size() -1 - (env.config.functionKeyDisplay == true ? 1 : 0));
	}
	/**
	 * XN[GfB^ĕ`悷D
	 */
	public void show(boolean mode) {
		// t@NVL[\
		displayFunctionKey();
		
		if(mode) {
			// eLXgʂĕ`悷
			env.stdout.flush();
		}
		// J[\\
		env.cursor.show();
	}
	/**
	 * t@NVL[\D
	 */
	public void displayFunctionKey() {
		if(env.config.functionKeyDisplay == true) {
			int[] data = new int[env.config.getCharsHorizonMax()];
			int begin = env.config.functionKeyDisplayShift ? 6 : 0;
			String[] functionKeys = env.config.functionKeyStrings;
			for(int i = 0; i < 6; i++) {
				char[] chars = functionKeys[begin + i].toCharArray();
				for(int j = 0; j < chars.length; j++) {
					data[i * 12 + j] = functionKeys[begin + i].charAt(j);
				}
			}
			env.stdout.tvram.vpoke(0, env.config.getCharsVerticalMaxActual() -1, data);
		}
	}
	/**
	 * vOsɖĂяoCxgnhD
	 * @param e CxgIuWFNg
	 */
	public void performEvent(BasicRuntimeEvent e) {
		if(breakFlag == false) {
			// CTRL+CĂȂȂCʂɂ邱ƂȂ
			return;
		}
		
		// CTRL+CꂽꍇCvOf̃tOݒ肷
		BasicRuntimeContext ctx = (BasicRuntimeContext)e.getSource();
		ctx.breakFlag = true;
		breakFlag = false;
	}
}
